/*
 * Decompiled with CFR 0.152.
 */
package opt.example;

import opt.EvaluationFunction;

public abstract class TravelingSalesmanEvaluationFunction
implements EvaluationFunction {
    private double[][] distances;

    public TravelingSalesmanEvaluationFunction(double[][] points) {
        this.distances = new double[points.length][];
        int i = 0;
        while (i < points.length) {
            this.distances[i] = new double[i];
            int j = 0;
            while (j < i) {
                double[] a = points[i];
                double[] b = points[j];
                this.distances[i][j] = Math.sqrt(Math.pow(a[0] - b[0], 2.0) + Math.pow(a[1] - b[1], 2.0));
                ++j;
            }
            ++i;
        }
    }

    public double getDistance(int i, int j) {
        if (i == j) {
            return 0.0;
        }
        int a = Math.max(i, j);
        int b = Math.min(i, j);
        return this.distances[a][b];
    }
}

