/*
 * Decompiled with CFR 0.152.
 */
package opt.example;

import dist.Distribution;
import opt.example.TravelingSalesmanEvaluationFunction;
import opt.ga.CrossoverFunction;
import shared.Instance;

public class TravelingSalesmanCrossOver
implements CrossoverFunction {
    private TravelingSalesmanEvaluationFunction eval;

    public TravelingSalesmanCrossOver(TravelingSalesmanEvaluationFunction eval) {
        this.eval = eval;
    }

    public Instance mate(Instance a, Instance b) {
        int[] nexta = new int[a.size()];
        int[] nextb = new int[b.size()];
        int i = 0;
        while (i < a.size() - 1) {
            nexta[a.getDiscrete((int)i)] = a.getDiscrete(i + 1);
            nextb[b.getDiscrete((int)i)] = b.getDiscrete(i + 1);
            ++i;
        }
        nexta[a.getDiscrete((int)(a.size() - 1))] = a.getDiscrete(0);
        nexta[b.getDiscrete((int)(b.size() - 1))] = b.getDiscrete(0);
        boolean[] visited = new boolean[a.size()];
        int[] child = new int[a.size()];
        child[0] = Distribution.random.nextInt(a.size());
        visited[child[0]] = true;
        int i2 = 0;
        while (i2 < child.length - 1) {
            int cur = child[i2];
            int na = nexta[cur];
            int nb = nextb[cur];
            int next = -1;
            if (visited[na] && !visited[nb]) {
                next = nb;
            } else if (visited[nb] && !visited[na]) {
                next = na;
            } else if (!visited[na] && !visited[nb]) {
                next = this.eval.getDistance(cur, na) < this.eval.getDistance(cur, nb) ? na : nb;
            } else {
                while (visited[next = Distribution.random.nextInt(a.size())]) {
                }
            }
            child[i2 + 1] = next;
            visited[next] = true;
            ++i2;
        }
        double[] data = new double[child.length];
        int i3 = 0;
        while (i3 < child.length) {
            data[i3] = child[i3];
            ++i3;
        }
        return new Instance(data);
    }
}

