/*
 * Decompiled with CFR 0.152.
 */
package opt.example;

import dist.Distribution;
import func.nn.NeuralNetwork;
import opt.ContinuousAddOneNeighbor;
import opt.EvaluationFunction;
import opt.HillClimbingProblem;
import opt.NeighborFunction;
import opt.example.NeuralNetworkEvaluationFunction;
import opt.example.NeuralNetworkWeightDistribution;
import opt.ga.ContinuousAddOneMutation;
import opt.ga.CrossoverFunction;
import opt.ga.GeneticAlgorithmProblem;
import opt.ga.MutationFunction;
import opt.ga.UniformCrossOver;
import shared.DataSet;
import shared.ErrorMeasure;
import shared.Instance;

public class NeuralNetworkOptimizationProblem
implements HillClimbingProblem,
GeneticAlgorithmProblem {
    private EvaluationFunction eval;
    private CrossoverFunction crossover;
    private NeighborFunction neighbor;
    private MutationFunction mutate;
    private Distribution dist;

    public NeuralNetworkOptimizationProblem(DataSet examples, NeuralNetwork network, ErrorMeasure measure) {
        this.eval = new NeuralNetworkEvaluationFunction(network, examples, measure);
        this.crossover = new UniformCrossOver();
        this.neighbor = new ContinuousAddOneNeighbor();
        this.mutate = new ContinuousAddOneMutation();
        this.dist = new NeuralNetworkWeightDistribution(network.getLinks().size());
    }

    public double value(Instance d) {
        return this.eval.value(d);
    }

    public Instance random() {
        return this.dist.sample(null);
    }

    public Instance neighbor(Instance d) {
        return this.neighbor.neighbor(d);
    }

    public Instance mate(Instance da, Instance db) {
        return this.crossover.mate(da, db);
    }

    public void mutate(Instance d) {
        this.mutate.mutate(d);
    }
}

