/*
 * Decompiled with CFR 0.152.
 */
package opt.example;

import func.nn.NeuralNetwork;
import opt.EvaluationFunction;
import shared.DataSet;
import shared.ErrorMeasure;
import shared.Instance;
import util.linalg.Vector;

public class NeuralNetworkEvaluationFunction
implements EvaluationFunction {
    private NeuralNetwork network;
    private DataSet examples;
    private ErrorMeasure measure;

    public NeuralNetworkEvaluationFunction(NeuralNetwork network, DataSet examples, ErrorMeasure measure) {
        this.network = network;
        this.examples = examples;
        this.measure = measure;
    }

    public double value(Instance d) {
        Vector weights = d.getData();
        this.network.setWeights(weights);
        double error = 0.0;
        int i = 0;
        while (i < this.examples.size()) {
            this.network.setInputValues(this.examples.get(i).getData());
            this.network.run();
            error += this.measure.value(new Instance(this.network.getOutputValues()), this.examples.get(i));
            ++i;
        }
        return 1.0 / error;
    }
}

