/*
 * Decompiled with CFR 0.152.
 */
package opt.example;

import opt.EvaluationFunction;
import shared.Instance;
import util.linalg.Vector;

public class KnapsackEvaluationFunction
implements EvaluationFunction {
    private double[] weights;
    private double[] volumes;
    private double maxVolume;
    private double maxVolumeSum;

    public KnapsackEvaluationFunction(double[] w, double[] v, double maxV, int[] maxC) {
        this.weights = w;
        this.volumes = v;
        this.maxVolume = maxV;
        int i = 0;
        while (i < v.length) {
            this.maxVolumeSum += (double)maxC[i] * v[i];
            ++i;
        }
    }

    public double value(Instance d) {
        Vector data = d.getData();
        double volume = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < data.size()) {
            volume += this.volumes[i] * data.get(i);
            value += this.weights[i] * data.get(i);
            ++i;
        }
        if (volume > this.maxVolume) {
            double smallNumber = 1.0E-10;
            return smallNumber * (this.maxVolumeSum - volume);
        }
        return value;
    }
}

