/*
 * Decompiled with CFR 0.152.
 */
package opt;

import dist.Distribution;
import opt.HillClimbingProblem;
import opt.OptimizationAlgorithm;
import shared.Instance;

public class SimulatedAnnealing
extends OptimizationAlgorithm {
    private Instance cur;
    private double curVal;
    private double t;
    private double cooling;

    public SimulatedAnnealing(double t, double cooling, HillClimbingProblem hcp) {
        super(hcp);
        this.t = t;
        this.cooling = cooling;
        this.cur = hcp.random();
        this.curVal = hcp.value(this.cur);
    }

    public double train() {
        Instance neigh;
        HillClimbingProblem p = (HillClimbingProblem)this.getOptimizationProblem();
        double neighVal = p.value(neigh = p.neighbor(this.cur));
        if (neighVal > this.curVal || Distribution.random.nextDouble() < Math.exp((neighVal - this.curVal) / this.t)) {
            this.curVal = neighVal;
            this.cur = neigh;
        }
        this.t *= this.cooling;
        return this.curVal;
    }

    public Instance getOptimal() {
        return this.cur;
    }
}

