/*
 * Decompiled with CFR 0.152.
 */
package func.test;

import dist.Distribution;
import dist.MultivariateGaussian;
import func.svm.LinearKernel;
import func.svm.PolynomialKernel;
import func.svm.RBFKernel;
import func.svm.SigmoidKernel;
import func.svm.SingleClassSequentialMinimalOptimization;
import func.svm.SingleClassSupportVectorMachine;
import shared.DataSet;
import shared.Instance;
import util.linalg.DenseVector;
import util.linalg.RectangularMatrix;

public class SingleClassSequentialMinimalOptimizationTest {
    public static void main(String[] args) {
        Instance[] instances = new Instance[100];
        boolean[] instancesRare = new boolean[100];
        MultivariateGaussian mga = new MultivariateGaussian(new DenseVector(new double[]{100.0, 100.0, 100.0}), RectangularMatrix.eye(3).times(0.01));
        MultivariateGaussian mgb = new MultivariateGaussian(new DenseVector(new double[]{-1.0, -1.0, -1.0}), RectangularMatrix.eye(3).times(1.0));
        int i = 0;
        while (i < instances.length) {
            if (Distribution.random.nextDouble() < 0.05) {
                instances[i] = mga.sample(null);
                instancesRare[i] = true;
            } else {
                instances[i] = mgb.sample(null);
            }
            ++i;
        }
        double avgP = 0.0;
        int i2 = 0;
        while (i2 < instances.length) {
            avgP += mga.p(instances[i2]);
            ++i2;
        }
        System.out.println("Average p : " + avgP / (double)instances.length);
        PolynomialKernel pk = new PolynomialKernel(2, true);
        LinearKernel lk = new LinearKernel();
        SigmoidKernel sk = new SigmoidKernel();
        RBFKernel rk = new RBFKernel(10.0);
        SingleClassSequentialMinimalOptimization smo = new SingleClassSequentialMinimalOptimization(new DataSet(instances), rk, 0.1);
        smo.train();
        SingleClassSupportVectorMachine svm = smo.getSupportVectorMachine();
        System.out.println(svm);
        System.out.println("Num iterations " + smo.getNumberOfIterations());
        System.out.println("Num svs " + svm.getSupportVectors().size());
        instances = svm.getSupportVectors().getInstances();
        avgP = 0.0;
        int i3 = 0;
        while (i3 < instances.length) {
            avgP += mga.p(instances[i3]);
            ++i3;
        }
        System.out.println("SV Average p: " + avgP / (double)instances.length);
    }
}

