/*
 * Decompiled with CFR 0.152.
 */
package func.svm;

import func.svm.Kernel;
import shared.DataSet;
import shared.Instance;

public class SingleClassSupportVectorMachine {
    private DataSet supportVectors;
    private double[] a;
    private Kernel kernel;
    private double b;

    public SingleClassSupportVectorMachine(DataSet supportVectors, double[] a, Kernel kernel, double b) {
        this.supportVectors = supportVectors;
        this.a = a;
        this.kernel = kernel;
        this.b = b;
        kernel.clear();
        kernel.setExamples(supportVectors);
    }

    public Instance value(Instance d) {
        return new Instance(this.margin(d) >= 0.0);
    }

    public double margin(Instance data) {
        double result = 0.0;
        int i = 0;
        while (i < this.supportVectors.size()) {
            result += this.a[i] * this.kernel.value(i, data);
            ++i;
        }
        return result -= this.b;
    }

    public DataSet getSupportVectors() {
        return this.supportVectors;
    }

    public String toString() {
        String ret = "b = " + this.b + "\n";
        ret = String.valueOf(ret) + "kernel = " + this.kernel + "\n";
        int i = 0;
        while (i < this.supportVectors.size()) {
            ret = String.valueOf(ret) + this.a[i] + " || " + this.supportVectors.get(i) + "\n";
            ++i;
        }
        return ret;
    }
}

