/*
 * Decompiled with CFR 0.152.
 */
package func.svm;

import func.svm.Kernel;
import func.svm.SingleClassSupportVectorMachine;
import shared.DataSet;
import shared.Instance;
import shared.Trainer;
import util.ABAGAILArrays;

public class SingleClassSequentialMinimalOptimization
implements Trainer {
    private static final double TOLERANCE = 1.0E-8;
    private static final double EPS = 1.0E-8;
    private static final double ZERO = 1.0E-8;
    private int iterations;
    private DataSet examples;
    private Kernel kernel;
    private double v;
    private double vl;
    private double[] a;
    private double p;

    public SingleClassSequentialMinimalOptimization(DataSet examples, Kernel kernel, double v) {
        this.v = v = Math.min(v, 1.0);
        this.kernel = kernel;
        this.examples = examples;
        kernel.clear();
        kernel.setExamples(examples);
        this.a = new double[examples.size()];
        this.vl = v * (double)examples.size();
        int ivl = (int)this.vl;
        int[] indices = ABAGAILArrays.indices(examples.size());
        ABAGAILArrays.permute(indices);
        int i = 0;
        while (i < ivl) {
            this.a[indices[i]] = 1.0 / this.vl;
            ++i;
        }
        if ((double)ivl != this.vl) {
            double remainder;
            this.a[indices[ivl]] = remainder = 1.0 - 1.0 / this.vl * (double)ivl;
        }
        this.p = this.output(indices[0]);
        i = 1;
        while (i < this.a.length && this.a[indices[i]] > 0.0) {
            this.p = Math.max(this.p, this.output(indices[i]));
            ++i;
        }
    }

    public double train() {
        int numChanged = 0;
        boolean examineAll = true;
        while (numChanged > 0 | examineAll) {
            int i;
            ++this.iterations;
            numChanged = 0;
            if (examineAll) {
                i = 0;
                while (i < this.a.length) {
                    if (this.examine(i)) {
                        ++numChanged;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.a.length) {
                    if (!this.isBound(i) && this.examine(i)) {
                        ++numChanged;
                    }
                    ++i;
                }
            }
            if (examineAll) {
                examineAll = false;
                continue;
            }
            if (numChanged != 0) continue;
            examineAll = true;
        }
        this.p -= 1.0E-8;
        return 0.0;
    }

    public SingleClassSupportVectorMachine getSupportVectorMachine() {
        int supportVectorCount = 0;
        int i = 0;
        while (i < this.a.length) {
            if (this.a[i] != 0.0) {
                ++supportVectorCount;
            }
            ++i;
        }
        Instance[] support = new Instance[supportVectorCount];
        double[] supporta = new double[supportVectorCount];
        int j = 0;
        int i2 = 0;
        while (i2 < this.a.length) {
            if (this.a[i2] != 0.0) {
                support[j] = this.examples.get(i2);
                supporta[j] = this.a[i2];
                ++j;
            }
            ++i2;
        }
        DataSet supportSet = new DataSet(support);
        supportSet.setDescription(this.examples.getDescription());
        return new SingleClassSupportVectorMachine(supportSet, supporta, this.kernel, this.p);
    }

    public int getNumberOfIterations() {
        return this.iterations;
    }

    private final boolean examine(int j) {
        int startI;
        double oj = this.output(j);
        if (!((oj - this.p) * this.a[j] > 1.0E-8) && !((this.p - oj) * (1.0 / this.vl - this.a[j]) > 1.0E-8)) {
            return false;
        }
        int i = -1;
        double max = 0.0;
        int k = 0;
        while (k < this.a.length) {
            double oi = this.output(k);
            if (!this.isBound(k) && Math.abs(oj - oi) >= max) {
                max = Math.abs(oj - oi);
                i = k;
            }
            ++k;
        }
        if (i != -1 && this.takeStep(i, j, oj)) {
            return true;
        }
        i = startI = (int)Math.random() * this.a.length;
        do {
            if (this.isBound(i) || !this.takeStep(i, j, oj)) continue;
            return true;
        } while ((i = (i + 1) % this.a.length) != startI);
        i = startI = (int)Math.random() * this.a.length;
        do {
            if (!this.takeStep(i, j, oj)) continue;
            return true;
        } while ((i = (i + 1) % this.a.length) != startI);
        return false;
    }

    private final boolean takeStep(int i, int j, double oj) {
        int startK;
        double h;
        if (i == j) {
            return false;
        }
        double oi = this.output(i);
        double kii = this.kernel.value(i, i);
        double kij = this.kernel.value(i, j);
        double kjj = this.kernel.value(j, j);
        double ci = oi - this.a[i] * kii - this.a[j] * kij;
        double cj = oj - this.a[i] * kij - this.a[j] * kjj;
        double d = this.a[i] + this.a[j];
        double l = Math.max(0.0, d - 1.0 / this.vl);
        if (l == (h = Math.min(1.0 / this.vl, d))) {
            return false;
        }
        double aj = (d * (kii - kij) + ci - cj) / (kii + kjj - 2.0 * kij);
        if (aj < l) {
            aj = l;
        } else if (aj > h) {
            aj = h;
        }
        if (aj < 1.0E-8) {
            aj = 0.0;
        } else if (aj > 1.0 / this.vl - 1.0E-8) {
            aj = 1.0 / this.vl;
        }
        if (Math.abs(aj - this.a[j]) < 1.0E-8 * (aj + this.a[j] + 1.0E-8)) {
            return false;
        }
        double ai = d - aj;
        if (ai < 1.0E-8) {
            ai = 0.0;
        } else if (ai > 1.0 / this.vl - 1.0E-8) {
            ai = 1.0 / this.vl;
        }
        this.a[i] = ai;
        this.a[j] = aj;
        if (!this.isBound(i)) {
            this.p = this.output(i);
            return true;
        }
        if (!this.isBound(j)) {
            this.p = this.output(j);
            return true;
        }
        int k = startK = (int)Math.random() * this.a.length;
        do {
            if (this.isBound(k)) continue;
            this.p = this.output(j);
            return true;
        } while ((k = (k + 1) % this.a.length) != startK);
        this.p = Double.NEGATIVE_INFINITY;
        k = 0;
        while (k < this.a.length) {
            if (this.a[k] > 0.0) {
                this.p = Math.max(this.p, this.output(k));
            }
            ++k;
        }
        return true;
    }

    private final boolean isBound(int i) {
        return this.a[i] <= 0.0 || this.a[i] >= 1.0 / this.vl;
    }

    private final double output(int i) {
        double result = 0.0;
        int j = 0;
        while (j < this.a.length) {
            if (this.a[j] != 0.0) {
                result += this.a[j] * this.kernel.value(i, j);
            }
            ++j;
        }
        return result;
    }

    public String toString() {
        String ret = "p = " + this.p + "\n";
        ret = String.valueOf(ret) + "kernel = " + this.kernel + "\n";
        ret = String.valueOf(ret) + this.examples.toString();
        return ret;
    }
}

