/*
 * Decompiled with CFR 0.152.
 */
package func.svm;

import func.svm.Kernel;
import shared.Instance;

public class SigmoidKernel
extends Kernel {
    private double dotProductWeight;
    private double additiveConstant;

    public SigmoidKernel(double dotProductWeight, double additiveConstant) {
        this.dotProductWeight = dotProductWeight;
        this.additiveConstant = additiveConstant;
    }

    public SigmoidKernel(boolean addOne) {
        this(1.0, 0.0);
        if (addOne) {
            this.additiveConstant = 1.0;
        }
    }

    public SigmoidKernel() {
        this(false);
    }

    public double value(Instance a, Instance b) {
        return this.tanh(this.dotProductWeight * a.getData().dotProduct(b.getData()) + this.additiveConstant);
    }

    public double tanh(double value) {
        double e2x = Math.exp(2.0 * value);
        if (e2x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return (e2x - 1.0) / (e2x + 1.0);
    }

    public String toString() {
        return "Polynomial Kernel tanh(" + this.dotProductWeight + "*K(xi,xj) + " + this.additiveConstant + ")";
    }
}

