/*
 * Decompiled with CFR 0.152.
 */
package func.svm;

import func.svm.Kernel;
import func.svm.LinearKernel;
import func.svm.SupportVectorMachine;
import shared.DataSet;
import shared.Instance;
import shared.Trainer;
import util.linalg.DenseVector;
import util.linalg.Vector;

public class SequentialMinimalOptimization
implements Trainer {
    private static final double TOLERANCE = 1.0E-4;
    private static final double EPS = 1.0E-4;
    private static final double ZERO = 1.0E-8;
    private int iterations;
    private DataSet examples;
    private Kernel kernel;
    private double c;
    private double[] a;
    private double b;
    private double[] e;
    private Vector w;

    public SequentialMinimalOptimization(DataSet examples, Kernel kernel, double c) {
        this.c = c;
        this.kernel = kernel;
        this.examples = examples;
        this.a = new double[examples.size()];
        this.b = 0.0;
        this.e = new double[examples.size()];
        kernel.clear();
        kernel.setExamples(examples);
        if (kernel instanceof LinearKernel) {
            this.w = new DenseVector(new double[examples.get(0).size()]);
        }
    }

    public double train() {
        int numChanged = 0;
        boolean examineAll = true;
        while (numChanged > 0 | examineAll) {
            int i;
            ++this.iterations;
            numChanged = 0;
            if (examineAll) {
                i = 0;
                while (i < this.a.length) {
                    if (this.examine(i)) {
                        ++numChanged;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.a.length) {
                    if (!this.isBound(i) && this.examine(i)) {
                        ++numChanged;
                    }
                    ++i;
                }
            }
            if (examineAll) {
                examineAll = false;
                continue;
            }
            if (numChanged != 0) continue;
            examineAll = true;
        }
        return 0.0;
    }

    public SupportVectorMachine getSupportVectorMachine() {
        int supportVectorCount = 0;
        int i = 0;
        while (i < this.a.length) {
            if (this.a[i] != 0.0) {
                ++supportVectorCount;
            }
            ++i;
        }
        Instance[] support = new Instance[supportVectorCount];
        double[] supporta = new double[supportVectorCount];
        int j = 0;
        int i2 = 0;
        while (i2 < this.a.length) {
            if (this.a[i2] != 0.0) {
                support[j] = this.examples.get(i2);
                supporta[j] = this.a[i2];
                ++j;
            }
            ++i2;
        }
        DataSet supportSet = new DataSet(support);
        supportSet.setDescription(this.examples.getDescription());
        return new SupportVectorMachine(supportSet, supporta, this.kernel, this.b);
    }

    public int getNumberOfIterations() {
        return this.iterations;
    }

    private final boolean examine(int j) {
        int startI;
        int k;
        double ei;
        int i;
        double ej = this.error(j);
        double rj = ej * this.examples.get(j).getLabel().getPlusMinus();
        if (!(rj < -1.0E-4 && this.a[j] < this.c || rj > 1.0E-4 && this.a[j] > 0.0)) {
            return false;
        }
        if (ej > 0.0) {
            i = -1;
            ei = ej;
            k = 0;
            while (k < this.a.length) {
                if (!this.isBound(k) && this.e[k] < ei) {
                    ei = this.e[k];
                    i = k;
                }
                ++k;
            }
            if (i != -1 && this.takeStep(i, j, ej)) {
                return true;
            }
        }
        if (ej < 0.0) {
            i = -1;
            ei = ej;
            k = 0;
            while (k < this.a.length) {
                if (!this.isBound(k) && this.e[k] > ei) {
                    ei = this.e[k];
                    i = k;
                }
                ++k;
            }
            if (i != -1 && this.takeStep(i, j, ej)) {
                return true;
            }
        }
        int i2 = startI = (int)Math.random() * this.a.length;
        do {
            if (this.isBound(i2) || !this.takeStep(i2, j, ej)) continue;
            return true;
        } while ((i2 = (i2 + 1) % this.a.length) != startI);
        i2 = startI = (int)Math.random() * this.a.length;
        do {
            if (!this.takeStep(i2, j, ej)) continue;
            return true;
        } while ((i2 = (i2 + 1) % this.a.length) != startI);
        return false;
    }

    private final boolean takeStep(int i, int j, double ej) {
        double bnew;
        double aj;
        double kjj;
        double h;
        double l;
        if (i == j) {
            return false;
        }
        double yi = this.examples.get(i).getLabel().getPlusMinus();
        double yj = this.examples.get(j).getLabel().getPlusMinus();
        double s = yi * yj;
        double ei = this.error(i);
        if (s < 0.0) {
            l = Math.max(0.0, this.a[j] - this.a[i]);
            h = Math.min(this.c, this.c + this.a[j] - this.a[i]);
        } else {
            l = Math.max(0.0, this.a[i] + this.a[j] - this.c);
            h = Math.min(this.c, this.a[i] + this.a[j]);
        }
        if (l == h) {
            return false;
        }
        double kii = this.kernel.value(i, i);
        double kij = this.kernel.value(i, j);
        double eta = 2.0 * kij - kii - (kjj = this.kernel.value(j, j));
        if (eta < 0.0) {
            aj = this.a[j] - yj * (ei - ej) / eta;
            if (aj < l) {
                aj = l;
            } else if (aj > h) {
                aj = h;
            }
        } else {
            double fl = this.a[i] + s * this.a[j] - s * l;
            double fiold = ei + yi;
            double vi = fiold + this.b - yi * this.a[i] * kii - yj * this.a[j] * kij;
            double fjold = ej + yj;
            double vj = fjold + this.b - yi * this.a[i] * kij - yj * this.a[j] * kjj;
            double objl = fl + l - 0.5 * kii * fl * fl - 0.5 * kjj * l * l - s * kij * fl * l - yi * fl * vi - yj * l * vj;
            double fh = this.a[i] + s * this.a[j] - s * h;
            double objh = fh + h - 0.5 * kii * fh * fh - 0.5 * kjj * h * h - s * kij * fh * h - yi * fh * vi - yj * h * vj;
            aj = objl > objh + 1.0E-4 ? l : (objl < objh - 1.0E-4 ? h : this.a[j]);
        }
        if (aj < 1.0E-8) {
            aj = 0.0;
        } else if (aj > this.c - 1.0E-8) {
            aj = this.c;
        }
        if (Math.abs(aj - this.a[j]) < 1.0E-4 * (aj + this.a[j] + 1.0E-4)) {
            return false;
        }
        double ai = this.a[i] + s * (this.a[j] - aj);
        if (ai < 1.0E-8) {
            ai = 0.0;
        } else if (ai > this.c - 1.0E-8) {
            ai = this.c;
        }
        if (ai > 0.0 && ai < this.c) {
            bnew = ei + yi * (ai - this.a[i]) * kii + yj * (aj - this.a[j]) * kij + this.b;
        } else if (aj > 0.0 && aj < this.c) {
            bnew = ej + yi * (ai - this.a[i]) * kij + yj * (aj - this.a[j]) * kjj + this.b;
        } else {
            double bi = ei + yi * (ai - this.a[i]) * kii + yj * (aj - this.a[j]) * kij + this.b;
            double bj = ej + yi * (ai - this.a[i]) * kij + yj * (aj - this.a[j]) * kjj + this.b;
            bnew = (bi + bj) / 2.0;
        }
        if (ai > 0.0 && ai < this.c) {
            this.e[i] = 0.0;
        }
        if (aj > 0.0 && aj < this.c) {
            this.e[j] = 0.0;
        }
        double ti = yi * (ai - this.a[i]);
        double tj = yj * (aj - this.a[j]);
        double tb = this.b - bnew;
        if (this.w != null) {
            this.w = this.examples.get(i).getData().times(ti).plus(this.w);
            this.w = this.examples.get(j).getData().times(tj).plus(this.w);
        }
        int k = 0;
        while (k < this.e.length) {
            if (k != i && k != j && !this.isBound(k)) {
                int n = k;
                this.e[n] = this.e[n] + (ti * this.kernel.value(i, k) + tj * this.kernel.value(j, k) + tb);
            }
            ++k;
        }
        this.b = bnew;
        this.a[i] = ai;
        this.a[j] = aj;
        return true;
    }

    private final boolean isBound(int i) {
        return this.a[i] <= 0.0 || this.a[i] >= this.c;
    }

    private final double error(int i) {
        if (!this.isBound(i)) {
            return this.e[i];
        }
        return this.evaluate(i) - this.examples.get(i).getLabel().getPlusMinus();
    }

    private final double evaluate(int i) {
        if (this.w != null) {
            return this.examples.get(i).getData().dotProduct(this.w) - this.b;
        }
        double result = 0.0;
        int j = 0;
        while (j < this.a.length) {
            if (this.a[j] != 0.0) {
                result += this.examples.get(j).getLabel().getPlusMinus() * this.a[j] * this.kernel.value(i, j);
            }
            ++j;
        }
        return result -= this.b;
    }

    public String toString() {
        String ret = "b = " + this.b + "\n";
        ret = String.valueOf(ret) + "kernel = " + this.kernel + "\n";
        ret = String.valueOf(ret) + this.examples.toString();
        return ret;
    }
}

