/*
 * Decompiled with CFR 0.152.
 */
package func.svm;

import func.svm.Kernel;
import shared.Instance;
import util.linalg.Vector;

public class RBFKernel
extends Kernel {
    private double sigma;
    private double gamma;

    public RBFKernel(double sigma) {
        this.sigma = sigma;
        this.gamma = -1.0 / (2.0 * sigma * sigma);
    }

    public double value(Instance a, Instance b) {
        Vector va = a.getData();
        Vector vb = b.getData();
        double difference = va.dotProduct(va) + vb.dotProduct(vb) - 2.0 * va.dotProduct(vb);
        return Math.exp(this.gamma * difference);
    }

    public String toString() {
        return "RBF Kernel sigma = " + this.sigma;
    }
}

