/*
 * Decompiled with CFR 0.152.
 */
package func.svm;

import func.svm.Kernel;
import shared.Instance;

public class PolynomialKernel
extends Kernel {
    private double dotProductWeight;
    private double additiveConstant;
    private int exponent;

    public PolynomialKernel(double dotProductWeight, double additiveConstant, int exponent) {
        this.dotProductWeight = dotProductWeight;
        this.additiveConstant = additiveConstant;
        this.exponent = exponent;
    }

    public PolynomialKernel(int exponent) {
        this(exponent, false);
    }

    public PolynomialKernel(int exponent, boolean addOne) {
        this(1.0, 0.0, exponent);
        if (addOne) {
            this.additiveConstant = 1.0;
        }
    }

    public double value(Instance a, Instance b) {
        return Math.pow(this.dotProductWeight * a.getData().dotProduct(b.getData()) + this.additiveConstant, this.exponent);
    }

    public String toString() {
        return "Polynomial Kernel (" + this.dotProductWeight + "*K(xi,xj) + " + this.additiveConstant + ")^" + this.exponent;
    }
}

