/*
 * Decompiled with CFR 0.152.
 */
package func.nn.backprop;

import func.nn.backprop.BackPropagationLink;
import func.nn.backprop.WeightUpdateRule;

public class RPROPUpdateRule
extends WeightUpdateRule {
    private static final double INCREASE = 1.2;
    private static final double DECREASE = 0.5;
    private double initialLearningRate;
    private double maxLearningRate;
    private double minLearningRate;

    public RPROPUpdateRule(double initial, double max, double min) {
        this.initialLearningRate = initial;
        this.maxLearningRate = max;
        this.minLearningRate = min;
    }

    public RPROPUpdateRule() {
        this(0.1, 50.0, 1.0E-6);
    }

    public void update(BackPropagationLink link) {
        if (link.getLearningRate() == 0.0) {
            link.setLearningRate(this.initialLearningRate);
        }
        double sign = 0.0;
        if (link.getError() < 0.0) {
            sign = -1.0;
        } else if (link.getError() > 0.0) {
            sign = 1.0;
        }
        if (link.getLastError() * link.getError() > 0.0) {
            link.setLearningRate(Math.min(link.getLearningRate() * 1.2, this.maxLearningRate));
            link.changeWeight(-sign * link.getLearningRate());
        } else if (link.getLastError() * link.getError() < 0.0) {
            link.setLearningRate(Math.max(link.getLearningRate() * 0.5, this.minLearningRate));
            link.setError(0.0);
            link.changeWeight(-link.getLastChange());
        } else {
            link.changeWeight(-sign * link.getLearningRate());
        }
    }
}

