/*
 * Decompiled with CFR 0.152.
 */
package func.nn.backprop;

import func.nn.backprop.BackPropagationLink;
import func.nn.backprop.WeightUpdateRule;

public class QuickpropUpdateRule
extends WeightUpdateRule {
    private double learningRate;

    public QuickpropUpdateRule(double learningRate) {
        this.learningRate = learningRate;
    }

    public QuickpropUpdateRule() {
        this(0.2);
    }

    public void update(BackPropagationLink link) {
        if (link.getLastError() == 0.0) {
            link.changeWeight(-this.learningRate * link.getError());
        } else {
            link.changeWeight(link.getError() / (link.getLastError() - link.getError()) * link.getLastChange() - this.learningRate * link.getError());
        }
    }
}

