/*
 * Decompiled with CFR 0.152.
 */
package func.nn.backprop;

import func.nn.FeedForwardNode;
import func.nn.Link;
import func.nn.activation.DifferentiableActivationFunction;
import func.nn.backprop.BackPropagationLink;
import func.nn.backprop.WeightUpdateRule;

public class BackPropagationNode
extends FeedForwardNode {
    private double inputError;
    private double outputError;

    public BackPropagationNode(DifferentiableActivationFunction function) {
        super(function);
    }

    public void backpropagate() {
        if (this.getOutLinkCount() > 0) {
            double weightedErrorSum = 0.0;
            int i = 0;
            while (i < this.getOutLinkCount()) {
                BackPropagationLink outLink = (BackPropagationLink)this.getOutLink(i);
                weightedErrorSum += outLink.getWeightedOutError();
                ++i;
            }
            this.setOutputError(weightedErrorSum);
            DifferentiableActivationFunction act = (DifferentiableActivationFunction)this.getActivationFunction();
            this.setInputError(act.derivative(this.getWeightedInputSum()) * this.getOutputError());
        } else {
            this.setInputError(this.getOutputError());
        }
    }

    public void backpropagateLinks() {
        int i = 0;
        while (i < this.getInLinkCount()) {
            BackPropagationLink inLink = (BackPropagationLink)this.getInLink(i);
            inLink.backpropagate();
            ++i;
        }
    }

    public void updateWeights(WeightUpdateRule rule) {
        int i = 0;
        while (i < this.getInLinkCount()) {
            BackPropagationLink inLink = (BackPropagationLink)this.getInLink(i);
            rule.update(inLink);
            ++i;
        }
    }

    public void setOutputError(double error) {
        this.outputError = error;
    }

    public double getOutputError() {
        return this.outputError;
    }

    public double getInputError() {
        return this.inputError;
    }

    public void setInputError(double error) {
        this.inputError = error;
    }

    public void clearError() {
        int i = 0;
        while (i < this.getInLinkCount()) {
            BackPropagationLink inLink = (BackPropagationLink)this.getInLink(i);
            inLink.clearError();
            ++i;
        }
    }

    public Link createLink() {
        return new BackPropagationLink();
    }
}

