/*
 * Decompiled with CFR 0.152.
 */
package func.nn.backprop;

import func.nn.Layer;
import func.nn.activation.DifferentiableActivationFunction;
import func.nn.activation.HyperbolicTangentSigmoid;
import func.nn.activation.LinearActivationFunction;
import func.nn.activation.LogisticSigmoid;
import func.nn.backprop.BackPropagationBiasNode;
import func.nn.backprop.BackPropagationLayer;
import func.nn.backprop.BackPropagationNetwork;
import func.nn.backprop.BackPropagationNode;
import func.nn.backprop.BackPropagationSoftMaxOutputLayer;

public class BackPropagationNetworkFactory {
    private BackPropagationNetwork createNetwork(int[] nodeCounts, DifferentiableActivationFunction transfer, Layer outputLayer, DifferentiableActivationFunction outputFunction) {
        if (nodeCounts.length < 2) {
            throw new IllegalArgumentException();
        }
        BackPropagationNetwork network = new BackPropagationNetwork();
        BackPropagationLayer inputLayer = new BackPropagationLayer();
        int i = 0;
        while (i < nodeCounts[0]) {
            inputLayer.addNode(new BackPropagationNode(null));
            ++i;
        }
        inputLayer.addNode(new BackPropagationBiasNode(1.0));
        network.setInputLayer(inputLayer);
        i = 1;
        while (i < nodeCounts.length - 1) {
            BackPropagationLayer hiddenLayer = new BackPropagationLayer();
            int j = 0;
            while (j < nodeCounts[i]) {
                hiddenLayer.addNode(new BackPropagationNode(transfer));
                ++j;
            }
            hiddenLayer.addNode(new BackPropagationBiasNode(1.0));
            network.addHiddenLayer(hiddenLayer);
            ++i;
        }
        i = 0;
        while (i < nodeCounts[nodeCounts.length - 1]) {
            outputLayer.addNode(new BackPropagationNode(outputFunction));
            ++i;
        }
        network.setOutputLayer(outputLayer);
        network.connect();
        return network;
    }

    public BackPropagationNetwork createRegressionNetwork(int[] nodeCounts, DifferentiableActivationFunction transfer) {
        return this.createNetwork(nodeCounts, transfer, new BackPropagationLayer(), new LinearActivationFunction());
    }

    public BackPropagationNetwork createRegressionNetwork(int[] nodeCounts) {
        return this.createRegressionNetwork(nodeCounts, new HyperbolicTangentSigmoid());
    }

    public BackPropagationNetwork createClassificationNetwork(int[] nodeCounts, DifferentiableActivationFunction transfer) {
        if (nodeCounts[nodeCounts.length - 1] == 1) {
            return this.createNetwork(nodeCounts, transfer, new BackPropagationLayer(), new LogisticSigmoid());
        }
        return this.createNetwork(nodeCounts, transfer, new BackPropagationSoftMaxOutputLayer(), new LinearActivationFunction());
    }

    public BackPropagationNetwork createClassificationNetwork(int[] nodeCounts) {
        return this.createClassificationNetwork(nodeCounts, new HyperbolicTangentSigmoid());
    }
}

