/*
 * Decompiled with CFR 0.152.
 */
package func.nn.backprop;

import func.nn.FeedForwardNetwork;
import func.nn.backprop.BackPropagationLayer;
import func.nn.backprop.WeightUpdateRule;

public class BackPropagationNetwork
extends FeedForwardNetwork {
    public void backpropagate() {
        ((BackPropagationLayer)this.getOutputLayer()).backpropagate();
        int i = this.getHiddenLayerCount() - 1;
        while (i >= 0) {
            ((BackPropagationLayer)this.getHiddenLayer(i)).backpropagate();
            --i;
        }
    }

    public void clearError() {
        ((BackPropagationLayer)this.getOutputLayer()).clearError();
        int i = this.getHiddenLayerCount() - 1;
        while (i >= 0) {
            ((BackPropagationLayer)this.getHiddenLayer(i)).clearError();
            --i;
        }
    }

    public void updateWeights(WeightUpdateRule rule) {
        ((BackPropagationLayer)this.getOutputLayer()).updateWeights(rule);
        int i = this.getHiddenLayerCount() - 1;
        while (i >= 0) {
            ((BackPropagationLayer)this.getHiddenLayer(i)).updateWeights(rule);
            --i;
        }
    }

    public void setOutputErrors(double[] errors) {
        ((BackPropagationLayer)this.getOutputLayer()).setOutputErrors(errors);
    }
}

