/*
 * Decompiled with CFR 0.152.
 */
package func.nn.backprop;

import func.nn.Link;
import func.nn.backprop.BackPropagationNode;

public class BackPropagationLink
extends Link {
    private double error;
    private double lastError;
    private double lastChange;
    private double learningRate;

    public void changeWeight(double delta) {
        super.changeWeight(delta);
        this.lastChange = delta;
    }

    public void backpropagate() {
        this.addError(this.getInValue() * this.getOutError());
    }

    public void addError(double error) {
        this.error += error;
    }

    public void clearError() {
        this.lastError = this.error;
        this.error = 0.0;
    }

    public double getError() {
        return this.error;
    }

    public void setError(double error) {
        this.error = error;
    }

    public double getLastChange() {
        return this.lastChange;
    }

    public double getLastError() {
        return this.lastError;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getOutError() {
        return ((BackPropagationNode)this.getOutNode()).getInputError();
    }

    public double getWeightedOutError() {
        return ((BackPropagationNode)this.getOutNode()).getInputError() * this.getWeight();
    }

    public double getInError() {
        return ((BackPropagationNode)this.getInNode()).getInputError();
    }

    public double getWeightedInError() {
        return ((BackPropagationNode)this.getInNode()).getInputError() * this.getWeight();
    }
}

