/*
 * Decompiled with CFR 0.152.
 */
package func.nn;

import func.nn.Layer;
import func.nn.NeuralNetwork;
import java.util.ArrayList;
import java.util.List;
import util.linalg.Vector;

public abstract class LayeredNetwork
extends NeuralNetwork {
    private Layer inputLayer;
    private Layer outputLayer;
    private List hiddenLayers = new ArrayList();
    private List links = null;

    public Vector getOutputValues() {
        return this.outputLayer.getActivations();
    }

    public void setInputValues(Vector values) {
        this.inputLayer.setActivations(values);
    }

    public int getDiscreteOutputValue() {
        return this.outputLayer.getGreatestActivationIndex();
    }

    public boolean getBinaryOutputValue() {
        return this.outputLayer.getNode(0).getActivation() > 0.5;
    }

    public Layer getInputLayer() {
        return this.inputLayer;
    }

    public List getHiddenLayers() {
        return this.hiddenLayers;
    }

    public Layer getOutputLayer() {
        return this.outputLayer;
    }

    public void setInputLayer(Layer layer) {
        this.inputLayer = layer;
    }

    public void setOutputLayer(Layer layer) {
        this.outputLayer = layer;
    }

    public int getHiddenLayerCount() {
        return this.hiddenLayers.size();
    }

    public Layer getHiddenLayer(int i) {
        return (Layer)this.hiddenLayers.get(i);
    }

    public void addHiddenLayer(Layer layer) {
        this.hiddenLayers.add(this.hiddenLayers.size(), layer);
    }

    public void disconnect() {
        if (this.inputLayer != null && this.getHiddenLayerCount() > 0) {
            Layer firstMiddle = this.getHiddenLayer(0);
            this.inputLayer.disconnect(firstMiddle);
        } else if (this.inputLayer != null && this.outputLayer != null) {
            this.inputLayer.disconnect(this.outputLayer);
        }
        int i = 0;
        while (i + 1 < this.getHiddenLayerCount()) {
            Layer first = this.getHiddenLayer(i);
            Layer second = this.getHiddenLayer(i + 1);
            first.disconnect(second);
            ++i;
        }
        if (this.outputLayer != null && this.getHiddenLayerCount() > 0) {
            Layer lastMiddle = this.getHiddenLayer(this.getHiddenLayerCount() - 1);
            lastMiddle.disconnect(this.outputLayer);
        }
    }

    public void connect() {
        if (this.inputLayer != null && this.getHiddenLayerCount() > 0) {
            Layer firstMiddle = this.getHiddenLayer(0);
            this.inputLayer.connect(firstMiddle);
        } else if (this.inputLayer != null && this.outputLayer != null) {
            this.inputLayer.connect(this.outputLayer);
        }
        int i = 0;
        while (i + 1 < this.getHiddenLayerCount()) {
            Layer first = this.getHiddenLayer(i);
            Layer second = this.getHiddenLayer(i + 1);
            first.connect(second);
            ++i;
        }
        if (this.outputLayer != null && this.getHiddenLayerCount() > 0) {
            Layer lastMiddle = this.getHiddenLayer(this.getHiddenLayerCount() - 1);
            lastMiddle.connect(this.outputLayer);
        }
    }

    public List getLinks() {
        if (this.links != null) {
            return this.links;
        }
        this.links = new ArrayList();
        this.links.addAll(this.inputLayer.getLinks());
        int i = 0;
        while (i < this.getHiddenLayerCount()) {
            this.links.addAll(this.getHiddenLayer(i).getLinks());
            ++i;
        }
        this.links.addAll(this.outputLayer.getLinks());
        return this.links;
    }
}

