/*
 * Decompiled with CFR 0.152.
 */
package func.nn;

import func.nn.Neuron;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import util.linalg.DenseVector;
import util.linalg.Vector;

public class Layer
implements Serializable {
    private List nodes = new ArrayList();

    public int getNodeCount() {
        return this.nodes.size();
    }

    public Neuron getNode(int i) {
        return (Neuron)this.nodes.get(i);
    }

    public void addNode(Neuron node) {
        this.nodes.add(node);
    }

    public void setActivations(Vector values) {
        int i = 0;
        while (i < values.size()) {
            this.getNode(i).setActivation(values.get(i));
            ++i;
        }
    }

    public Vector getActivations() {
        double[] values = new double[this.getNodeCount()];
        int i = 0;
        while (i < values.length) {
            values[i] = this.getNode(i).getActivation();
            ++i;
        }
        return new DenseVector(values);
    }

    public int getGreatestActivationIndex() {
        int largest = 0;
        double largestValue = this.getNode(largest).getActivation();
        int i = 1;
        while (i < this.getNodeCount()) {
            if (this.getNode(i).getActivation() > largestValue) {
                largest = i;
            }
            ++i;
        }
        return largest;
    }

    public void connect(Layer layer) {
        int i = 0;
        while (i < this.getNodeCount()) {
            Neuron node = this.getNode(i);
            int j = 0;
            while (j < layer.getNodeCount()) {
                node.connect(layer.getNode(j));
                ++j;
            }
            ++i;
        }
    }

    public void disconnect(Layer layer) {
        int i = 0;
        while (i < this.getNodeCount()) {
            Neuron node = this.getNode(i);
            int j = 0;
            while (j < layer.getNodeCount()) {
                node.disconnect(layer.getNode(i));
                ++j;
            }
            ++i;
        }
    }

    public List getLinks() {
        ArrayList links = new ArrayList();
        int i = 0;
        while (i < this.nodes.size()) {
            Neuron n = (Neuron)this.nodes.get(i);
            links.addAll(n.getInLinks());
            ++i;
        }
        return links;
    }
}

