/*
 * Decompiled with CFR 0.152.
 */
package func.inst;

import shared.Instance;
import util.MaxHeap;

public class NearestNeighborQueue {
    private MaxHeap queue;
    private int k;
    private double maxDistance;

    public NearestNeighborQueue(int k, double maxDistance) {
        this.k = k;
        this.queue = new MaxHeap(k);
        this.maxDistance = maxDistance;
    }

    public NearestNeighborQueue(double maxDistance) {
        this(Integer.MAX_VALUE, maxDistance);
    }

    public NearestNeighborQueue(int k) {
        this(k, Double.POSITIVE_INFINITY);
    }

    public NearestNeighborQueue() {
        this(1);
    }

    public void add(Instance o, double distance) {
        if (distance <= this.getMaxDistance()) {
            this.queue.add(o, distance);
            if (this.queue.size() > this.k) {
                this.queue.extractMax();
            }
        }
    }

    public double getMaxDistance() {
        if (this.queue.size() < this.k) {
            return this.maxDistance;
        }
        return this.queue.getMaxKey();
    }

    public Instance[] getNearest() {
        Object[] data = this.queue.getData();
        Instance[] results = new Instance[this.queue.size()];
        int i = 0;
        while (i < results.length) {
            results[i] = (Instance)data[i];
            ++i;
        }
        return results;
    }
}

