/*
 * Decompiled with CFR 0.152.
 */
package func.inst;

import func.inst.HyperRectangle;
import func.inst.KDTreeNode;
import func.inst.NearestNeighborQueue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import shared.DataSet;
import shared.DistanceMeasure;
import shared.EuclideanDistance;
import shared.Instance;

public class KDTree
implements Serializable {
    private static final Random random = new Random();
    private KDTreeNode head;
    private int dimensions;
    private DistanceMeasure distanceMeasure;

    public KDTree(DataSet keys, DistanceMeasure distance) {
        this.dimensions = keys.get(0).size();
        this.distanceMeasure = distance;
        KDTreeNode[] nodes = new KDTreeNode[keys.size()];
        int i = 0;
        while (i < keys.size()) {
            nodes[i] = new KDTreeNode(keys.get(i));
            ++i;
        }
        this.head = this.buildTree(nodes, 0, nodes.length);
    }

    public KDTree(DataSet keys) {
        this(keys, new EuclideanDistance());
    }

    private KDTreeNode buildTree(KDTreeNode[] nodes, int start, int end) {
        if (start >= end) {
            return null;
        }
        if (start + 1 == end) {
            return nodes[start];
        }
        int splitterIndex = this.chooseSplitterRandom(nodes, start, end);
        KDTreeNode splitter = nodes[splitterIndex];
        splitterIndex = this.partition(nodes, start, end, splitterIndex);
        splitter.setLeft(this.buildTree(nodes, start, splitterIndex));
        splitter.setRight(this.buildTree(nodes, splitterIndex + 1, end));
        return splitter;
    }

    private int partition(Comparable[] comparables, int start, int end, int splitterIndex) {
        this.swap(comparables, splitterIndex, end - 1);
        splitterIndex = end - 1;
        Comparable splitter = comparables[splitterIndex];
        int i = start - 1;
        int j = start;
        while (j < end - 1) {
            if (splitter.compareTo(comparables[j]) > 0) {
                this.swap(comparables, ++i, j);
            }
            ++j;
        }
        this.swap(comparables, splitterIndex, i + 1);
        return i + 1;
    }

    private void swap(Object[] objects, int i, int j) {
        Object temp = objects[i];
        objects[i] = objects[j];
        objects[j] = temp;
    }

    private int chooseSplitterRandom(KDTreeNode[] nodes, int start, int end) {
        int splitter = random.nextInt(end - start) + start;
        int dimension = random.nextInt(this.dimensions);
        nodes[splitter].setDimension(dimension);
        return splitter;
    }

    private int chooseSplitterSmart(KDTreeNode[] nodes, int start, int end) {
        double[] min = new double[this.dimensions];
        Arrays.fill(min, Double.POSITIVE_INFINITY);
        double[] max = new double[this.dimensions];
        Arrays.fill(max, Double.NEGATIVE_INFINITY);
        int i = start;
        while (i < end) {
            Instance key = nodes[i].getInstance();
            int j = 0;
            while (j < this.dimensions) {
                min[j] = Math.min(min[j], key.getContinuous(j));
                max[j] = Math.max(max[j], key.getContinuous(j));
                ++j;
            }
            ++i;
        }
        int widestDimension = 0;
        double widestWidth = max[0] - min[0];
        int i2 = 1;
        while (i2 < this.dimensions) {
            if (max[i2] - min[i2] > widestWidth) {
                widestDimension = i2;
                widestWidth = max[i2] - min[i2];
            }
            ++i2;
        }
        double median = (max[widestDimension] - min[widestDimension]) / 2.0;
        double bestDifference = Double.POSITIVE_INFINITY;
        int splitterIndex = -1;
        int i3 = start;
        while (i3 < end) {
            KDTreeNode node = nodes[i3];
            if (Math.abs(node.getInstance().getContinuous(widestDimension) - median) < bestDifference) {
                splitterIndex = i3;
                bestDifference = Math.abs(node.getInstance().getContinuous(widestDimension) - median);
            }
            ++i3;
        }
        nodes[splitterIndex].setDimension(widestDimension);
        return splitterIndex;
    }

    public Instance[] knn(Instance target, int k) {
        NearestNeighborQueue results = new NearestNeighborQueue(k);
        this.knn(this.head, target, new HyperRectangle(this.dimensions), results);
        return results.getNearest();
    }

    public Instance[] nn(Instance target) {
        NearestNeighborQueue results = new NearestNeighborQueue();
        this.knn(this.head, target, new HyperRectangle(this.dimensions), results);
        return results.getNearest();
    }

    public Instance[] range(Instance target, double range) {
        NearestNeighborQueue results = new NearestNeighborQueue(range);
        this.knn(this.head, target, new HyperRectangle(this.dimensions), results);
        return results.getNearest();
    }

    public Instance[] knnrange(Instance target, int k, double range) {
        NearestNeighborQueue results = new NearestNeighborQueue(k, range);
        this.knn(this.head, target, new HyperRectangle(this.dimensions), results);
        return results.getNearest();
    }

    private void knn(KDTreeNode node, Instance target, HyperRectangle hr, NearestNeighborQueue results) {
        KDTreeNode farNode;
        HyperRectangle farHR;
        KDTreeNode nearNode;
        HyperRectangle nearHR;
        if (node == null) {
            return;
        }
        HyperRectangle leftHR = hr.splitLeft(node.getSplitValue(), node.getDimension());
        HyperRectangle rightHR = hr.splitRight(node.getSplitValue(), node.getDimension());
        if (target.getContinuous(node.getDimension()) < node.getSplitValue()) {
            nearHR = leftHR;
            nearNode = node.getLeft();
            farHR = rightHR;
            farNode = node.getRight();
        } else {
            nearHR = rightHR;
            nearNode = node.getRight();
            farHR = leftHR;
            farNode = node.getLeft();
        }
        this.knn(nearNode, target, nearHR, results);
        if (this.distanceMeasure.value(farHR.pointNearestTo(target), target) <= results.getMaxDistance()) {
            results.add(node.getInstance(), this.distanceMeasure.value(node.getInstance(), target));
            this.knn(farNode, target, farHR, results);
        }
    }
}

