/*
 * Decompiled with CFR 0.152.
 */
package func.inst;

import java.util.Arrays;
import shared.Copyable;
import shared.Instance;
import util.linalg.DenseVector;
import util.linalg.Vector;

public class HyperRectangle
implements Copyable {
    private Vector min;
    private Vector max;

    public HyperRectangle(Vector min, Vector max) {
        this.min = min;
        this.max = max;
    }

    public HyperRectangle(int k) {
        double[] maxd = new double[k];
        Arrays.fill(maxd, Double.POSITIVE_INFINITY);
        this.max = new DenseVector(maxd);
        double[] mind = new double[k];
        Arrays.fill(mind, Double.NEGATIVE_INFINITY);
        this.min = new DenseVector(mind);
    }

    public Vector getMinimumValues() {
        return this.min;
    }

    public void setMinimumValues(Vector min) {
        this.min = min;
    }

    public Vector getMaximumValues() {
        return this.max;
    }

    public void setMaximumValues(Vector max) {
        this.max = max;
    }

    public HyperRectangle splitLeft(double value, int dimension) {
        HyperRectangle clone = (HyperRectangle)this.copy();
        clone.getMaximumValues().set(dimension, value);
        return clone;
    }

    public HyperRectangle splitRight(double value, int dimension) {
        HyperRectangle clone = (HyperRectangle)this.copy();
        clone.getMinimumValues().set(dimension, value);
        return clone;
    }

    public Instance pointNearestTo(Instance target) {
        double[] nearest = new double[target.size()];
        int i = 0;
        while (i < nearest.length) {
            nearest[i] = target.getContinuous(i) <= this.min.get(i) ? this.min.get(i) : (target.getContinuous(i) >= this.max.get(i) ? this.max.get(i) : target.getContinuous(i));
            ++i;
        }
        return new Instance(new DenseVector(nearest));
    }

    public Copyable copy() {
        return new HyperRectangle((Vector)this.min.copy(), (Vector)this.max.copy());
    }
}

