/*
 * Decompiled with CFR 0.152.
 */
package func.dtree;

import func.dtree.DecisionTreeSplitStatistics;
import func.dtree.SplitEvaluator;

public class InformationGainSplitEvaluator
extends SplitEvaluator {
    private static final double LOG2 = Math.log(2.0);

    private double entropy(double[] classProbabilities) {
        double entropy = 0.0;
        int i = 0;
        while (i < classProbabilities.length) {
            if (classProbabilities[i] != 0.0) {
                entropy -= classProbabilities[i] * Math.log(classProbabilities[i]) / LOG2;
            }
            ++i;
        }
        return entropy;
    }

    public double splitValue(DecisionTreeSplitStatistics stats) {
        double initialEntropy = this.entropy(stats.getClassProbabilities());
        double conditionalEntropy = 0.0;
        int i = 0;
        while (i < stats.getBranchCount()) {
            conditionalEntropy += stats.getBranchProbability(i) * this.entropy(stats.getConditionalClassProbabilities(i));
            ++i;
        }
        return initialEntropy - conditionalEntropy;
    }
}

