/*
 * Decompiled with CFR 0.152.
 */
package func.dtree;

import func.dtree.DecisionTreeSplit;
import shared.DataSet;

public class DecisionTreeSplitStatistics {
    private int[] instanceCounts;
    private double[] classProbabilities;
    private double[][] conditionalClassProbabilities;
    private double[] branchProbabilities;

    public DecisionTreeSplitStatistics(DecisionTreeSplit split, DataSet instances) {
        int classRange = instances.getDescription().getLabelDescription().getDiscreteRange();
        this.instanceCounts = new int[split.getNumberOfBranches()];
        this.classProbabilities = new double[classRange];
        this.conditionalClassProbabilities = new double[split.getNumberOfBranches()][classRange];
        this.branchProbabilities = new double[split.getNumberOfBranches()];
        double weightSum = 0.0;
        int i = 0;
        while (i < instances.size()) {
            int branch;
            double weight = instances.get(i).getWeight();
            int n = branch = split.getBranchOf(instances.get(i));
            this.instanceCounts[n] = this.instanceCounts[n] + 1;
            int n2 = instances.get(i).getLabel().getDiscrete();
            this.classProbabilities[n2] = this.classProbabilities[n2] + weight;
            int n3 = branch;
            this.branchProbabilities[n3] = this.branchProbabilities[n3] + weight;
            double[] dArray = this.conditionalClassProbabilities[branch];
            int n4 = instances.get(i).getLabel().getDiscrete();
            dArray[n4] = dArray[n4] + weight;
            weightSum += weight;
            ++i;
        }
        i = 0;
        while (i < this.conditionalClassProbabilities.length) {
            if (this.branchProbabilities[i] != 0.0) {
                int j = 0;
                while (j < this.conditionalClassProbabilities[i].length) {
                    double[] dArray = this.conditionalClassProbabilities[i];
                    int n = j++;
                    dArray[n] = dArray[n] / this.branchProbabilities[i];
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.classProbabilities.length) {
            int n = i++;
            this.classProbabilities[n] = this.classProbabilities[n] / weightSum;
        }
        i = 0;
        while (i < this.branchProbabilities.length) {
            int n = i++;
            this.branchProbabilities[n] = this.branchProbabilities[n] / weightSum;
        }
    }

    public double[] getBranchProbabilities() {
        return this.branchProbabilities;
    }

    public int getBranchCount() {
        return this.branchProbabilities.length;
    }

    public double getBranchProbability(int branch) {
        return this.branchProbabilities[branch];
    }

    public double[] getClassProbabilities() {
        return this.classProbabilities;
    }

    public int getClassCount() {
        return this.classProbabilities.length;
    }

    public double getClassProbability(int c) {
        return this.classProbabilities[c];
    }

    public double[][] getConditionalClassProbabilities() {
        return this.conditionalClassProbabilities;
    }

    public double[] getConditionalClassProbabilities(int branch) {
        return this.conditionalClassProbabilities[branch];
    }

    public int[] getInstanceCounts() {
        return this.instanceCounts;
    }

    public int getInstanceCount(int branch) {
        return this.instanceCounts[branch];
    }

    public int getMostLikelyClass() {
        int mostLikely = 0;
        int i = 1;
        while (i < this.classProbabilities.length) {
            if (this.classProbabilities[i] > this.classProbabilities[mostLikely]) {
                mostLikely = i;
            }
            ++i;
        }
        return mostLikely;
    }
}

