/*
 * Decompiled with CFR 0.152.
 */
package func.dtree;

import func.dtree.DecisionTreeSplit;
import func.dtree.DecisionTreeSplitStatistics;

public class DecisionTreeNode {
    private DecisionTreeSplit split;
    private DecisionTreeSplitStatistics stats;
    private DecisionTreeNode[] nodes;

    public DecisionTreeNode(DecisionTreeSplit split, DecisionTreeSplitStatistics stats, DecisionTreeNode[] nodes) {
        this.split = split;
        this.stats = stats;
        this.nodes = nodes;
    }

    public boolean isLeaf() {
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public DecisionTreeSplit getSplit() {
        return this.split;
    }

    public DecisionTreeSplitStatistics getSplitStatistics() {
        return this.stats;
    }

    public DecisionTreeNode[] getNodes() {
        return this.nodes;
    }

    public DecisionTreeNode getNode(int branch) {
        return this.nodes[branch];
    }

    public String toString(String indentation) {
        String ret = String.valueOf(indentation) + this.split.toString() + "\n";
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i] != null) {
                ret = String.valueOf(ret) + this.nodes[i].toString("\t" + indentation);
            } else {
                double[] probabilities = this.stats.getInstanceCount(i) == 0 ? this.stats.getClassProbabilities() : this.stats.getConditionalClassProbabilities(i);
                ret = String.valueOf(ret) + indentation;
                int j = 0;
                while (j < probabilities.length) {
                    ret = String.valueOf(ret) + probabilities[j] + " ";
                    ++j;
                }
                ret = String.valueOf(ret) + "\n";
            }
            ++i;
        }
        return ret;
    }

    public String toString() {
        return this.toString("");
    }
}

