/*
 * Decompiled with CFR 0.152.
 */
package func;

import dist.AbstractConditionalDistribution;
import dist.DiscreteDistribution;
import dist.Distribution;
import func.FunctionApproximater;
import func.svm.Kernel;
import func.svm.LinearKernel;
import func.svm.SequentialMinimalOptimization;
import func.svm.SupportVectorMachine;
import shared.DataSet;
import shared.Instance;
import shared.filt.DiscreteToBinaryFilter;

public class SimpleSupportVectorMachineClassifier
extends AbstractConditionalDistribution
implements FunctionApproximater {
    private SupportVectorMachine svm;
    private Kernel kernel;
    private double c;

    public SimpleSupportVectorMachineClassifier() {
        this(1.0, new LinearKernel());
    }

    public SimpleSupportVectorMachineClassifier(double c, Kernel kernel) {
        this.c = c;
        this.kernel = kernel;
    }

    public void estimate(DataSet set) {
        DiscreteToBinaryFilter dtbf = new DiscreteToBinaryFilter();
        dtbf.filter(set);
        SequentialMinimalOptimization smo = new SequentialMinimalOptimization(set, this.kernel, this.c);
        this.svm = smo.getSupportVectorMachine();
    }

    public Instance value(Instance i) {
        return this.svm.value(i);
    }

    public Distribution distributionFor(Instance data) {
        Instance v = this.value(data);
        double[] p = new double[2];
        p[v.getDiscrete()] = 1.0;
        return new DiscreteDistribution(p);
    }

    public double getC() {
        return this.c;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setC(double d) {
        this.c = d;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }
}

