/*
 * Decompiled with CFR 0.152.
 */
package func;

import dist.AbstractConditionalDistribution;
import dist.DiscreteDistribution;
import dist.Distribution;
import func.FunctionApproximater;
import shared.DataSet;
import shared.DistanceMeasure;
import shared.EuclideanDistance;
import shared.Instance;
import util.linalg.DenseVector;

public class KMeansClusterer
extends AbstractConditionalDistribution
implements FunctionApproximater {
    private Instance[] clusterCenters;
    private int k;
    private DistanceMeasure distanceMeasure;

    public KMeansClusterer(int k) {
        this.k = k;
        this.distanceMeasure = new EuclideanDistance();
    }

    public KMeansClusterer() {
        this(2);
    }

    public Distribution distributionFor(Instance instance) {
        double[] distribution = new double[this.k];
        int i = 0;
        while (i < this.k) {
            int n = i;
            distribution[n] = distribution[n] + 1.0 / this.distanceMeasure.value(instance, this.clusterCenters[i]);
            ++i;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < distribution.length) {
            sum += distribution[i2];
            ++i2;
        }
        if (Double.isInfinite(sum)) {
            sum = 0.0;
            i2 = 0;
            while (i2 < distribution.length) {
                if (Double.isInfinite(distribution[i2])) {
                    distribution[i2] = 1.0;
                    sum += 1.0;
                } else {
                    distribution[i2] = 0.0;
                }
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < distribution.length) {
            int n = i2++;
            distribution[n] = distribution[n] / sum;
        }
        return new DiscreteDistribution(distribution);
    }

    public void estimate(DataSet set) {
        this.clusterCenters = new Instance[this.k];
        int[] assignments = new int[set.size()];
        int i = 0;
        while (i < this.clusterCenters.length) {
            int pick;
            while (assignments[pick = Distribution.random.nextInt(set.size())] != 0) {
            }
            assignments[pick] = 1;
            this.clusterCenters[i] = (Instance)set.get(pick).copy();
            ++i;
        }
        boolean changed = false;
        do {
            changed = false;
            int i2 = 0;
            while (i2 < set.size()) {
                int closest = 0;
                double closestDistance = this.distanceMeasure.value(set.get(i2), this.clusterCenters[0]);
                int j = 1;
                while (j < this.k) {
                    double distance = this.distanceMeasure.value(set.get(i2), this.clusterCenters[j]);
                    if (distance < closestDistance) {
                        closestDistance = distance;
                        closest = j;
                    }
                    ++j;
                }
                if (assignments[i2] != closest) {
                    changed = true;
                }
                assignments[i2] = closest;
                ++i2;
            }
            if (!changed) continue;
            double[] assignmentCount = new double[this.k];
            int i3 = 0;
            while (i3 < this.k) {
                this.clusterCenters[i3].setData(new DenseVector(this.clusterCenters[i3].getData().size()));
                ++i3;
            }
            i3 = 0;
            while (i3 < set.size()) {
                this.clusterCenters[assignments[i3]].getData().plusEquals(set.get(i3).getData().times(set.get(i3).getWeight()));
                int n = assignments[i3];
                assignmentCount[n] = assignmentCount[n] + set.get(i3).getWeight();
                ++i3;
            }
            i3 = 0;
            while (i3 < this.k) {
                this.clusterCenters[i3].getData().timesEquals(1.0 / assignmentCount[i3]);
                ++i3;
            }
        } while (changed);
    }

    public Instance value(Instance data) {
        return this.distributionFor(data).mode();
    }

    public Instance[] getClusterCenters() {
        return this.clusterCenters;
    }

    public String toString() {
        String result = "k = " + this.k + "\n";
        int i = 0;
        while (i < this.clusterCenters.length) {
            result = String.valueOf(result) + this.clusterCenters[i].toString() + "\n";
            ++i;
        }
        return result;
    }
}

