/*
 * Decompiled with CFR 0.152.
 */
package func;

import dist.AbstractConditionalDistribution;
import dist.Distribution;
import dist.UnivariateGaussian;
import func.FunctionApproximater;
import func.svm.Kernel;
import func.svm.LinearKernel;
import shared.DataSet;
import shared.Instance;
import util.linalg.CholeskyFactorization;
import util.linalg.DenseVector;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.Vector;

public class GaussianProcessRegression
extends AbstractConditionalDistribution
implements FunctionApproximater {
    private Kernel kernel;
    private double noiseSigma;
    private Matrix c;
    private CholeskyFactorization cf;
    private Vector a;

    public GaussianProcessRegression(Kernel k, double noise) {
        this.kernel = k;
        this.noiseSigma = noise;
    }

    public GaussianProcessRegression() {
        this(new LinearKernel(), 1.0);
    }

    public void estimate(DataSet set) {
        this.c = new RectangularMatrix(set.size(), set.size());
        this.kernel.setExamples(set);
        int i = 0;
        while (i < this.c.m()) {
            int j = 0;
            while (j < this.c.n()) {
                this.c.set(i, j, this.kernel.value(i, j));
                ++j;
            }
            ++i;
        }
        this.c.plusEquals(RectangularMatrix.eye(set.size()).times(this.noiseSigma * this.noiseSigma));
        DenseVector t = new DenseVector(set.size());
        int i2 = 0;
        while (i2 < ((Vector)t).size()) {
            ((Vector)t).set(i2, set.get(i2).getLabel().getContinuous());
            ++i2;
        }
        this.cf = new CholeskyFactorization(this.c);
        this.a = this.cf.solve(t);
    }

    public Instance value(Instance i) {
        return this.distributionFor(i).mode();
    }

    public Distribution distributionFor(Instance instance) {
        DenseVector k = new DenseVector(this.c.m());
        int i = 0;
        while (i < ((Vector)k).size()) {
            ((Vector)k).set(i, this.kernel.value(i, instance));
            ++i;
        }
        double mean = this.a.dotProduct(k);
        double sigma = Math.sqrt(this.kernel.value(instance, instance) - k.dotProduct(this.cf.solve(k)));
        return new UnivariateGaussian(mean, sigma);
    }
}

