/*
 * Decompiled with CFR 0.152.
 */
package func;

import dist.AbstractConditionalDistribution;
import dist.DiscreteDistribution;
import dist.Distribution;
import dist.MixtureDistribution;
import dist.MultivariateGaussian;
import func.FunctionApproximater;
import func.KMeansClusterer;
import java.util.Arrays;
import shared.DataSet;
import shared.Instance;

public class EMClusterer
extends AbstractConditionalDistribution
implements FunctionApproximater {
    private static final double TOLERANCE = 1.0E-6;
    private static final int MAX_ITERATIONS = 1000;
    private MixtureDistribution mixture;
    private int k;
    private double tolerance;
    private int maxIterations;
    private int iterations;
    private boolean debug = false;

    public EMClusterer(int k, double tolerance, int maxIterations) {
        this.k = k;
        this.tolerance = tolerance;
        this.maxIterations = maxIterations;
    }

    public EMClusterer() {
        this(2, 1.0E-6, 1000);
    }

    public Distribution distributionFor(Instance instance) {
        double[] probs = new double[this.mixture.getComponents().length];
        double maxLog = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < probs.length) {
            probs[i] = this.mixture.getComponents()[i].logp(instance);
            maxLog = Math.max(maxLog, probs[i]);
            ++i;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < probs.length) {
            probs[i2] = Math.exp(probs[i2] - maxLog);
            sum += probs[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < probs.length) {
            int n = i2++;
            probs[n] = probs[n] / sum;
        }
        return new DiscreteDistribution(probs);
    }

    public void estimate(DataSet set) {
        KMeansClusterer kmeans = new KMeansClusterer(this.k);
        kmeans.estimate(set);
        double[] prior = new double[this.k];
        double weightSum = 0.0;
        int[] counts = new int[this.k];
        int[] classifications = new int[set.size()];
        int i = 0;
        while (i < set.size()) {
            classifications[i] = kmeans.value(set.get(i)).getDiscrete();
            int n = classifications[i];
            counts[n] = counts[n] + 1;
            int n2 = classifications[i];
            prior[n2] = prior[n2] + set.get(i).getWeight();
            weightSum += set.get(i).getWeight();
            ++i;
        }
        Instance[][] instances = new Instance[this.k][];
        int i2 = 0;
        while (i2 < instances.length) {
            instances[i2] = new Instance[counts[i2]];
            ++i2;
        }
        Arrays.fill(counts, 0);
        i2 = 0;
        while (i2 < set.size()) {
            instances[classifications[i2]][counts[classifications[i2]]] = set.get(i2);
            int n = classifications[i2];
            counts[n] = counts[n] + 1;
            ++i2;
        }
        Distribution[] initial = new MultivariateGaussian[this.k];
        int i3 = 0;
        while (i3 < initial.length) {
            initial[i3] = new MultivariateGaussian();
            ((MultivariateGaussian)initial[i3]).setDebug(this.debug);
            ((MultivariateGaussian)initial[i3]).estimate(new DataSet(instances[i3]));
            int n = i3++;
            prior[n] = prior[n] / weightSum;
        }
        this.mixture = new MixtureDistribution(initial, prior);
        boolean done = false;
        double lastLogLikelihood = 0.0;
        this.iterations = 0;
        while (!done) {
            if (this.debug) {
                System.out.println("On iteration " + this.iterations);
                System.out.println(this.mixture);
            }
            this.mixture.estimate(set);
            double logLikelihood = 0.0;
            int j = 0;
            while (j < set.size()) {
                logLikelihood += this.mixture.logp(set.get(j));
                ++j;
            }
            done = this.iterations > 0 && Math.abs(logLikelihood - lastLogLikelihood) < this.tolerance || this.iterations + 1 >= this.maxIterations;
            lastLogLikelihood = logLikelihood /= (double)set.size();
            ++this.iterations;
        }
    }

    public Instance value(Instance i) {
        return this.distributionFor(i).mode();
    }

    public int getIterations() {
        return this.iterations;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public MixtureDistribution getMixture() {
        return this.mixture;
    }

    public String toString() {
        return this.mixture.toString();
    }
}

