/*
 * Decompiled with CFR 0.152.
 */
package func;

import dist.AbstractConditionalDistribution;
import dist.DiscreteDistribution;
import dist.Distribution;
import func.DecisionStumpClassifier;
import func.FunctionApproximater;
import func.dtree.BinaryDecisionTreeSplit;
import func.dtree.DecisionTreeNode;
import func.dtree.DecisionTreeSplit;
import func.dtree.DecisionTreeSplitStatistics;
import func.dtree.InformationGainSplitEvaluator;
import func.dtree.PruningCriteria;
import func.dtree.SplitEvaluator;
import func.dtree.StandardDecisionTreeSplit;
import shared.DataSet;
import shared.DataSetDescription;
import shared.Instance;

public class DecisionTreeClassifier
extends AbstractConditionalDistribution
implements FunctionApproximater {
    private SplitEvaluator splitEvaluator;
    private PruningCriteria pruningCriteria;
    private DecisionTreeNode root;
    private boolean useBinarySplits;
    private int[] attributeRanges;
    private int classRange;

    public DecisionTreeClassifier(SplitEvaluator splitEvaluator, PruningCriteria pruningCriteria, boolean useBinarySplits) {
        this.splitEvaluator = splitEvaluator;
        this.pruningCriteria = pruningCriteria;
        this.useBinarySplits = useBinarySplits;
    }

    public DecisionTreeClassifier(SplitEvaluator splitEvaluator, boolean useBinarySplits) {
        this(splitEvaluator, null, useBinarySplits);
    }

    public DecisionTreeClassifier() {
        this(new InformationGainSplitEvaluator(), null, false);
    }

    public void estimate(DataSet instances) {
        if (instances.getDescription() == null) {
            DataSetDescription desc = new DataSetDescription();
            desc.induceFrom(instances);
            instances.setDescription(desc);
        }
        this.attributeRanges = new int[instances.getDescription().getAttributeTypes().length];
        int i = 0;
        while (i < this.attributeRanges.length) {
            this.attributeRanges[i] = instances.getDescription().getDiscreteRange(i);
            ++i;
        }
        this.root = this.buildTree(instances);
        if (this.root == null) {
            DecisionStumpClassifier stump = new DecisionStumpClassifier(this.splitEvaluator);
            stump.estimate(instances);
            this.root = stump.getStump();
        }
    }

    private DecisionTreeNode buildTree(DataSet instances) {
        int i;
        if (instances.size() == 0) {
            return null;
        }
        boolean allOfSameClass = true;
        int sameClass = instances.get(0).getLabel().getDiscrete();
        int i2 = 0;
        while (i2 < instances.size() && allOfSameClass) {
            allOfSameClass = instances.get(i2).getLabel().getDiscrete() == sameClass;
            ++i2;
        }
        if (allOfSameClass) {
            return null;
        }
        DecisionTreeSplit bestSplit = null;
        DecisionTreeSplitStatistics bestStats = null;
        double bestValue = Double.NEGATIVE_INFINITY;
        if (!this.useBinarySplits) {
            i = 0;
            while (i < this.attributeRanges.length) {
                StandardDecisionTreeSplit split = new StandardDecisionTreeSplit(i, this.attributeRanges[i]);
                DecisionTreeSplitStatistics stats = new DecisionTreeSplitStatistics(split, instances);
                double value = this.splitEvaluator.splitValue(stats);
                if (value > bestValue) {
                    bestValue = value;
                    bestSplit = split;
                    bestStats = stats;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.attributeRanges.length) {
                int j = 0;
                while (j < this.attributeRanges[i]) {
                    BinaryDecisionTreeSplit split = new BinaryDecisionTreeSplit(i, j);
                    DecisionTreeSplitStatistics stats = new DecisionTreeSplitStatistics(split, instances);
                    double value = this.splitEvaluator.splitValue(stats);
                    if (value > bestValue) {
                        bestValue = value;
                        bestSplit = split;
                        bestStats = stats;
                    }
                    ++j;
                }
                ++i;
            }
        }
        Instance[][] divided = new Instance[bestSplit.getNumberOfBranches()][];
        int nonZero = 0;
        int i3 = 0;
        while (i3 < divided.length) {
            divided[i3] = new Instance[bestStats.getInstanceCount(i3)];
            if (divided[i3].length != 0) {
                ++nonZero;
            }
            ++i3;
        }
        if (nonZero < 2) {
            return null;
        }
        int[] counters = new int[divided.length];
        int i4 = 0;
        while (i4 < instances.size()) {
            int branch = bestSplit.getBranchOf(instances.get(i4));
            divided[branch][counters[branch]] = instances.get(i4);
            int n = branch;
            counters[n] = counters[n] + 1;
            ++i4;
        }
        DecisionTreeNode[] nodes = new DecisionTreeNode[divided.length];
        int i5 = 0;
        while (i5 < nodes.length) {
            DataSet newSet = new DataSet(divided[i5], instances.getDescription());
            nodes[i5] = this.buildTree(newSet);
            ++i5;
        }
        DecisionTreeNode node = new DecisionTreeNode(bestSplit, bestStats, nodes);
        if (node.isLeaf() && this.pruningCriteria != null && this.pruningCriteria.shouldPrune(bestStats)) {
            return null;
        }
        return node;
    }

    public Distribution distributionFor(Instance instance) {
        DecisionTreeNode node = this.root;
        while (node.getNode(node.getSplit().getBranchOf(instance)) != null) {
            node = node.getNode(node.getSplit().getBranchOf(instance));
        }
        int branch = node.getSplit().getBranchOf(instance);
        if (node.getSplitStatistics().getInstanceCount(branch) == 0) {
            return new DiscreteDistribution(node.getSplitStatistics().getClassProbabilities());
        }
        return new DiscreteDistribution(node.getSplitStatistics().getConditionalClassProbabilities(branch));
    }

    public Instance value(Instance instance) {
        return this.distributionFor(instance).mode();
    }

    public DecisionTreeNode getRoot() {
        return this.root;
    }

    public SplitEvaluator getSplitEvaluator() {
        return this.splitEvaluator;
    }

    public PruningCriteria getPruningCriteria() {
        return this.pruningCriteria;
    }

    public boolean isUseBinarySplits() {
        return this.useBinarySplits;
    }

    public void setPruningCriteria(PruningCriteria criteria) {
        this.pruningCriteria = criteria;
    }

    public void setSplitEvaluator(SplitEvaluator evaluator) {
        this.splitEvaluator = evaluator;
    }

    public void setUseBinarySplits(boolean b) {
        this.useBinarySplits = b;
    }

    public int getHeight() {
        return this.height(this.root);
    }

    private int height(DecisionTreeNode root) {
        if (root == null) {
            return 0;
        }
        int height = 1;
        int i = 0;
        while (i < root.getNodes().length) {
            height = Math.max(height, 1 + this.height(root.getNode(i)));
            ++i;
        }
        return height;
    }

    public String toString() {
        return this.root.toString();
    }
}

