/*
 * Decompiled with CFR 0.152.
 */
package func;

import dist.AbstractConditionalDistribution;
import dist.DiscreteDistribution;
import dist.Distribution;
import func.FunctionApproximater;
import func.dtree.BinaryDecisionTreeSplit;
import func.dtree.DecisionTreeNode;
import func.dtree.DecisionTreeSplitStatistics;
import func.dtree.InformationGainSplitEvaluator;
import func.dtree.SplitEvaluator;
import shared.DataSet;
import shared.DataSetDescription;
import shared.Instance;

public class DecisionStumpClassifier
extends AbstractConditionalDistribution
implements FunctionApproximater {
    private SplitEvaluator splitEvaluator;
    private DecisionTreeNode stump;
    private int[] attributeRanges;

    public DecisionStumpClassifier(SplitEvaluator splitEvaluator) {
        this.splitEvaluator = splitEvaluator;
    }

    public DecisionStumpClassifier() {
        this(new InformationGainSplitEvaluator());
    }

    public void estimate(DataSet instances) {
        if (instances.getDescription() == null) {
            DataSetDescription desc = new DataSetDescription();
            desc.induceFrom(instances);
            instances.setDescription(desc);
        }
        this.attributeRanges = new int[instances.getDescription().getAttributeTypes().length];
        int i = 0;
        while (i < this.attributeRanges.length) {
            this.attributeRanges[i] = instances.getDescription().getDiscreteRange(i);
            ++i;
        }
        this.stump = this.buildStump(instances);
        if (this.stump == null) {
            throw new RuntimeException("Invalid Stump Exception");
        }
    }

    private DecisionTreeNode buildStump(DataSet instances) {
        BinaryDecisionTreeSplit bestSplit = null;
        DecisionTreeSplitStatistics bestStats = null;
        double bestValue = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.attributeRanges.length) {
            int j = 0;
            while (j < this.attributeRanges[i]) {
                BinaryDecisionTreeSplit split = new BinaryDecisionTreeSplit(i, j);
                DecisionTreeSplitStatistics stats = new DecisionTreeSplitStatistics(split, instances);
                double value = this.splitEvaluator.splitValue(stats);
                if (value > bestValue) {
                    bestValue = value;
                    bestSplit = split;
                    bestStats = stats;
                }
                ++j;
            }
            ++i;
        }
        DecisionTreeNode node = new DecisionTreeNode(bestSplit, bestStats, new DecisionTreeNode[bestStats.getBranchCount()]);
        return node;
    }

    public Distribution distributionFor(Instance instance) {
        int branch = this.stump.getSplit().getBranchOf(instance);
        if (this.stump.getSplitStatistics().getInstanceCount(branch) == 0) {
            return new DiscreteDistribution(this.stump.getSplitStatistics().getClassProbabilities());
        }
        return new DiscreteDistribution(this.stump.getSplitStatistics().getConditionalClassProbabilities(branch));
    }

    public Instance value(Instance i) {
        return this.distributionFor(i).mode();
    }

    public DecisionTreeNode getStump() {
        return this.stump;
    }

    public SplitEvaluator getSplitEvaluator() {
        return this.splitEvaluator;
    }

    public String toString() {
        return this.stump.toString();
    }
}

