/*
 * Decompiled with CFR 0.152.
 */
package func;

import dist.AbstractConditionalDistribution;
import dist.DiscreteDistribution;
import dist.Distribution;
import func.FunctionApproximater;
import shared.DataSet;
import shared.DataSetDescription;
import shared.Instance;

public class AdaBoostClassifier
extends AbstractConditionalDistribution
implements FunctionApproximater {
    private Class classifier;
    private FunctionApproximater[] classifiers;
    private double[] weights;
    private int classRange;
    private int size;
    static /* synthetic */ Class class$0;

    public AdaBoostClassifier(int size, Class classifier) {
        this.size = size;
        this.classifier = classifier;
    }

    public AdaBoostClassifier(int size) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("func.DecisionStumpClassifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(size, clazz);
    }

    public AdaBoostClassifier() {
        this(100);
    }

    public void estimate(DataSet instances) {
        this.classifiers = new FunctionApproximater[this.size];
        this.weights = new double[this.size];
        int i = 0;
        while (i < instances.size()) {
            instances.get(i).setWeight(1.0 / (double)instances.size());
            ++i;
        }
        if (instances.getDescription() == null) {
            DataSetDescription desc = new DataSetDescription();
            desc.induceFrom(instances);
            instances.setDescription(desc);
        }
        this.classRange = instances.getDescription().getLabelDescription().getDiscreteRange();
        i = 0;
        while (i < this.classifiers.length) {
            try {
                this.classifiers[i] = (FunctionApproximater)this.classifier.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.classifiers[i].estimate(instances);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Could not create " + this.classifier);
            }
            double error = 0.0;
            int j = 0;
            while (j < instances.size()) {
                if (this.classifiers[i].value(instances.get(j)).getDiscrete() != instances.get(j).getLabel().getDiscrete()) {
                    error += instances.get(j).getWeight();
                }
                ++j;
            }
            double beta = error / (1.0 - error);
            this.weights[i] = Math.log(1.0 / beta);
            if (error == 0.5) {
                this.classifiers[i] = null;
                break;
            }
            if (error == 0.0) break;
            double weightSum = 0.0;
            int j2 = 0;
            while (j2 < instances.size()) {
                if (this.classifiers[i].value(instances.get(j2)).getDiscrete() == instances.get(j2).getLabel().getDiscrete()) {
                    instances.get(j2).setWeight(instances.get(j2).getWeight() * beta);
                    weightSum += instances.get(j2).getWeight();
                } else {
                    weightSum += instances.get(j2).getWeight();
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < instances.size()) {
                instances.get(j2).setWeight(instances.get(j2).getWeight() / weightSum);
                ++j2;
            }
            ++i;
        }
    }

    public Instance value(Instance data) {
        double[] votes = new double[this.classRange];
        int i = 0;
        while (i < this.classifiers.length && this.classifiers[i] != null) {
            int n = this.classifiers[i].value(data).getDiscrete();
            votes[n] = votes[n] + this.weights[i];
            ++i;
        }
        int classification = 0;
        int i2 = 1;
        while (i2 < votes.length) {
            if (votes[i2] > votes[classification]) {
                classification = i2;
            }
            ++i2;
        }
        return new Instance(classification);
    }

    public Distribution distributionFor(Instance data) {
        Instance v = this.value(data);
        double[] p = new double[this.classRange];
        p[v.getDiscrete()] = 1.0;
        return new DiscreteDistribution(p);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int i) {
        this.size = i;
    }

    public FunctionApproximater[] getClassifiers() {
        return this.classifiers;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public String toString() {
        String ret = "";
        int i = 0;
        while (i < this.classifiers.length && this.classifiers[i] != null) {
            ret = String.valueOf(ret) + "weight " + this.weights[i] + "\n";
            ret = String.valueOf(ret) + this.classifiers[i] + "\n\n";
            ++i;
        }
        return ret;
    }
}

