/*
 * Decompiled with CFR 0.152.
 */
package dist.test;

import dist.DiscreteDistributionTable;
import dist.Distribution;
import dist.hmm.ForwardBackwardProbabilityCalculator;
import dist.hmm.HiddenMarkovModelReestimator;
import dist.hmm.ModularHiddenMarkovModel;
import dist.hmm.SimpleStateDistributionTable;
import dist.hmm.StateDistribution;
import dist.hmm.StateSequenceCalculator;
import shared.DataSet;
import shared.Instance;

public class HMMWumpusTest {
    private static int STATE_COUNT = 2;
    private static int INPUT_RANGE = 5;
    private static int SMELL_LEFT = 0;
    private static int SMELL_RIGHT = 1;
    private static int SMELL_UP = 2;
    private static int SMELL_DOWN = 3;
    private static int NO_SMELL = 4;
    private static int OUTPUT_RANGE = 4;
    private static int MOVE_LEFT = 0;
    private static int MOVE_RIGHT = 1;
    private static int MOVE_UP = 2;
    private static int MOVE_DOWN = 3;

    public static void main(String[] args) {
        ModularHiddenMarkovModel model = new ModularHiddenMarkovModel(STATE_COUNT);
        model.setOutputDistributions(new Distribution[]{DiscreteDistributionTable.random(INPUT_RANGE, OUTPUT_RANGE), DiscreteDistributionTable.random(INPUT_RANGE, OUTPUT_RANGE)});
        model.setTransitionDistributions(new StateDistribution[]{new SimpleStateDistributionTable(DiscreteDistributionTable.random(INPUT_RANGE, STATE_COUNT).getProbabilityMatrix()), new SimpleStateDistributionTable(DiscreteDistributionTable.random(INPUT_RANGE, STATE_COUNT).getProbabilityMatrix())});
        model.setInitialStateDistribution(new SimpleStateDistributionTable(DiscreteDistributionTable.random(INPUT_RANGE, STATE_COUNT).getProbabilityMatrix()));
        Instance[] sequence = new Instance[]{new Instance(NO_SMELL, MOVE_UP), new Instance(SMELL_LEFT, MOVE_RIGHT), new Instance(SMELL_RIGHT, MOVE_LEFT), new Instance(SMELL_UP, MOVE_DOWN), new Instance(SMELL_DOWN, MOVE_UP)};
        DataSet[] sequences = new DataSet[]{new DataSet(sequence)};
        System.out.println(model + "\n");
        System.out.println("Observation Sequences: ");
        int i = 0;
        while (i < sequences.length) {
            System.out.println(sequences[i]);
            ++i;
        }
        System.out.println();
        ForwardBackwardProbabilityCalculator fbc = new ForwardBackwardProbabilityCalculator(model, sequences[0]);
        System.out.println("Log probability of first sequence: ");
        System.out.println(fbc.calculateLogProbability());
        System.out.println();
        StateSequenceCalculator vc = new StateSequenceCalculator(model, sequences[0]);
        int[] states = vc.calculateStateSequence();
        System.out.println("Most likely state sequence of first sequence: ");
        int i2 = 0;
        while (i2 < states.length) {
            System.out.print(String.valueOf(states[i2]) + " ");
            ++i2;
        }
        System.out.println();
        System.out.println();
        System.out.println("Reestimations of model based on sequences: ");
        HiddenMarkovModelReestimator bwr = new HiddenMarkovModelReestimator(model, sequences);
        bwr.train();
        System.out.println(model + "\n");
        bwr.train();
        System.out.println(model + "\n");
        int i3 = 0;
        while (i3 < 20) {
            bwr.train();
            ++i3;
        }
        System.out.println(model + "\n");
        fbc = new ForwardBackwardProbabilityCalculator(model, sequences[0]);
        System.out.println("Log probability of first sequence: ");
        System.out.println(fbc.calculateLogProbability());
        System.out.println("Log probabilities of other sequences: ");
        i3 = 1;
        while (i3 < sequences.length) {
            fbc = new ForwardBackwardProbabilityCalculator(model, sequences[i3]);
            System.out.println(fbc.calculateLogProbability());
            ++i3;
        }
    }
}

