/*
 * Decompiled with CFR 0.152.
 */
package dist.test;

import dist.DiscreteDistribution;
import dist.Distribution;
import dist.hmm.ForwardBackwardProbabilityCalculator;
import dist.hmm.HiddenMarkovModelReestimator;
import dist.hmm.SimpleHiddenMarkovModel;
import dist.hmm.StateSequenceCalculator;
import java.util.Random;
import shared.DataSet;
import shared.Instance;

public class HMMRandomCoinTest {
    public static void main(String[] args) {
        SimpleHiddenMarkovModel model = new SimpleHiddenMarkovModel(2);
        model.setInitialStateProbabilities(new double[]{0.5, 0.5});
        model.setOutputDistributions(new Distribution[]{new DiscreteDistribution(new double[]{0.9, 0.1}), new DiscreteDistribution(new double[]{0.9, 0.1})});
        model.setTransitionProbabilities(new double[][]{{0.5, 0.5}, {0.5, 0.5}});
        Random random = new Random();
        Instance[] sequence = new Instance[1000];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = new Instance(random.nextInt(2));
            ++i;
        }
        DataSet[] sequences = new DataSet[]{new DataSet(sequence)};
        System.out.println(model + "\n");
        System.out.println("Observation Sequences: ");
        int i2 = 0;
        while (i2 < sequences.length) {
            System.out.println(sequences[i2]);
            ++i2;
        }
        System.out.println();
        ForwardBackwardProbabilityCalculator fbc = new ForwardBackwardProbabilityCalculator(model, sequences[0]);
        System.out.println("Log Probability of first sequence: ");
        System.out.println(fbc.calculateLogProbability());
        System.out.println();
        StateSequenceCalculator vc = new StateSequenceCalculator(model, sequences[0]);
        int[] states = vc.calculateStateSequence();
        System.out.println("Most likely state sequence of first sequence: ");
        int i3 = 0;
        while (i3 < states.length) {
            System.out.print(String.valueOf(states[i3]) + " ");
            ++i3;
        }
        System.out.println();
        System.out.println();
        System.out.println("Reestimations of model based on sequences: ");
        HiddenMarkovModelReestimator bwr = new HiddenMarkovModelReestimator(model, sequences);
        bwr.train();
        System.out.println(model + "\n");
        bwr.train();
        System.out.println(model + "\n");
        int i4 = 0;
        while (i4 < 1000) {
            bwr.train();
            ++i4;
        }
        System.out.println(model + "\n");
        fbc = new ForwardBackwardProbabilityCalculator(model, sequences[0]);
        System.out.println("Log Probability of first sequence: ");
        System.out.println(fbc.calculateLogProbability());
    }
}

