/*
 * Decompiled with CFR 0.152.
 */
package dist.test;

import dist.DiscreteDistribution;
import dist.DiscreteDistributionTable;
import dist.Distribution;
import dist.FixedComponentMixtureDistribution;
import dist.hmm.ForwardBackwardProbabilityCalculator;
import dist.hmm.HiddenMarkovModelReestimator;
import dist.hmm.ModularHiddenMarkovModel;
import dist.hmm.SimpleStateDistributionTable;
import dist.hmm.StateDistribution;
import java.util.Random;
import shared.ConvergenceTrainer;
import shared.DataSet;
import shared.Instance;

public class HMMConditionalMonsterKnowledgeTest {
    private static int SEQUENCE_COUNT = 5;
    private static int SEQUENCE_LENGTH = 100;
    private static int STATE_COUNT = 4;
    private static int INPUT_RANGE = 4;
    private static int SMELL_DAY = 0;
    private static int NO_SMELL_DAY = 1;
    private static int SMELL_NIGHT = 2;
    private static int NO_SMELL_NIGHT = 3;
    private static int OUTPUT_RANGE = 4;
    private static int RUN_AWAY = 0;
    private static int RUN_TOWARDS = 1;
    private static int STAY_STILL = 2;
    private static int SLEEP = 3;

    public static void main(String[] args) {
        int count = 0;
        int goodCount = 0;
        int iterations = 0;
        while (count < 1000) {
            Distribution[] knowledge = new Distribution[]{new DiscreteDistributionTable(new double[][]{{1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0}}), new DiscreteDistributionTable(new double[][]{{0.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}}), new DiscreteDistributionTable(new double[][]{{0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0}})};
            ModularHiddenMarkovModel model = new ModularHiddenMarkovModel(STATE_COUNT);
            model.setOutputDistributions(new Distribution[]{new FixedComponentMixtureDistribution(knowledge, DiscreteDistribution.random(knowledge.length).getProbabilities()), new FixedComponentMixtureDistribution(knowledge, DiscreteDistribution.random(knowledge.length).getProbabilities()), new FixedComponentMixtureDistribution(knowledge, DiscreteDistribution.random(knowledge.length).getProbabilities()), new FixedComponentMixtureDistribution(knowledge, DiscreteDistribution.random(knowledge.length).getProbabilities())});
            model.setTransitionDistributions(new StateDistribution[]{new SimpleStateDistributionTable(DiscreteDistributionTable.random(INPUT_RANGE, STATE_COUNT).getProbabilityMatrix()), new SimpleStateDistributionTable(DiscreteDistributionTable.random(INPUT_RANGE, STATE_COUNT).getProbabilityMatrix()), new SimpleStateDistributionTable(DiscreteDistributionTable.random(INPUT_RANGE, STATE_COUNT).getProbabilityMatrix()), new SimpleStateDistributionTable(DiscreteDistributionTable.random(INPUT_RANGE, STATE_COUNT).getProbabilityMatrix())});
            model.setInitialStateDistribution(new SimpleStateDistributionTable(DiscreteDistributionTable.random(INPUT_RANGE, STATE_COUNT).getProbabilityMatrix()));
            Instance[][] sequences = new Instance[SEQUENCE_COUNT][];
            Random random = new Random();
            int i = 0;
            while (i < sequences.length) {
                sequences[i] = new Instance[SEQUENCE_LENGTH];
                boolean smellSomething = random.nextBoolean();
                boolean day = random.nextBoolean();
                boolean isHungry = true;
                double smellProbability = random.nextDouble();
                double dayProbability = random.nextDouble();
                int j = 0;
                while (j < sequences[i].length) {
                    if (smellSomething && isHungry) {
                        if (day) {
                            sequences[i][j] = new Instance(SMELL_DAY);
                            sequences[i][j].setLabel(new Instance(RUN_TOWARDS));
                        } else {
                            sequences[i][j] = new Instance(SMELL_NIGHT);
                            sequences[i][j].setLabel(new Instance(RUN_TOWARDS));
                        }
                    } else if (smellSomething && !isHungry) {
                        if (day) {
                            sequences[i][j] = new Instance(SMELL_DAY);
                            sequences[i][j].setLabel(new Instance(RUN_AWAY));
                        } else {
                            sequences[i][j] = new Instance(SMELL_NIGHT);
                            sequences[i][j].setLabel(new Instance(RUN_AWAY));
                        }
                    } else if (day) {
                        sequences[i][j] = new Instance(NO_SMELL_DAY);
                        sequences[i][j].setLabel(new Instance(STAY_STILL));
                    } else {
                        sequences[i][j] = new Instance(NO_SMELL_NIGHT);
                        sequences[i][j].setLabel(new Instance(SLEEP));
                    }
                    if (random.nextDouble() < smellProbability) {
                        smellProbability = random.nextDouble();
                        if (smellSomething) {
                            smellSomething = false;
                            isHungry = !isHungry;
                        } else {
                            smellSomething = true;
                        }
                    }
                    if (random.nextDouble() < dayProbability) {
                        dayProbability = random.nextDouble();
                        day = !day;
                    }
                    ++j;
                }
                ++i;
            }
            DataSet[] dataSets = new DataSet[sequences.length];
            int i2 = 0;
            while (i2 < dataSets.length) {
                dataSets[i2] = new DataSet(sequences[i2]);
                ++i2;
            }
            System.out.println("Reestimations of model based on sequences: ");
            HiddenMarkovModelReestimator bwr = new HiddenMarkovModelReestimator(model, dataSets);
            ConvergenceTrainer trainer = new ConvergenceTrainer(bwr);
            trainer.train();
            iterations += trainer.getIterations();
            System.out.println(model + "\n");
            System.out.println("Log probabilities of sequences: ");
            boolean success = true;
            int i3 = 0;
            while (i3 < sequences.length) {
                ForwardBackwardProbabilityCalculator fbc = new ForwardBackwardProbabilityCalculator(model, dataSets[i3]);
                System.out.println(fbc.calculateLogProbability());
                if (success && fbc.calculateLogProbability() < -0.01) {
                    success = false;
                    System.out.println("FAILURE");
                }
                ++i3;
            }
            if (success) {
                ++goodCount;
            }
            System.out.println("So Far " + goodCount + " / " + ++count);
            System.out.println(String.valueOf(iterations) + " iterations");
        }
        System.out.println(String.valueOf(goodCount) + " / " + count);
        System.out.println(String.valueOf(iterations) + " iterations");
    }
}

