/*
 * Decompiled with CFR 0.152.
 */
package dist.test;

import dist.DiscreteDistribution;
import dist.Distribution;
import dist.hmm.ForwardBackwardProbabilityCalculator;
import dist.hmm.HiddenMarkovModelReestimator;
import dist.hmm.SimpleHiddenMarkovModel;
import dist.hmm.StateSequenceCalculator;
import shared.DataSet;
import shared.Instance;

public class HMMCoinTest {
    public static void main(String[] args) {
        SimpleHiddenMarkovModel model = new SimpleHiddenMarkovModel(2);
        model.setInitialStateProbabilities(new double[]{0.1, 0.9});
        model.setOutputDistributions(new Distribution[]{new DiscreteDistribution(new double[]{0.2, 0.8}), new DiscreteDistribution(new double[]{0.2, 0.8})});
        model.setTransitionProbabilities(new double[][]{{0.2, 0.8}, {0.9, 0.1}});
        DataSet sequence = new DataSet(new Instance[]{new Instance(1), new Instance(0)});
        DataSet[] sequences = new DataSet[]{sequence, new DataSet(new Instance[]{new Instance(1), new Instance(0)}), new DataSet(new Instance[]{new Instance(1), new Instance(0)}), new DataSet(new Instance[]{new Instance(1), new Instance(0)})};
        System.out.println(model + "\n");
        System.out.println("Observation Sequences: ");
        int i = 0;
        while (i < sequences.length) {
            System.out.println(sequences[i]);
            ++i;
        }
        System.out.println();
        ForwardBackwardProbabilityCalculator fbc = new ForwardBackwardProbabilityCalculator(model, sequence);
        System.out.println("Probability of first sequence: ");
        System.out.println(fbc.calculateProbability());
        System.out.println();
        StateSequenceCalculator vc = new StateSequenceCalculator(model, sequence);
        int[] states = vc.calculateStateSequence();
        System.out.println("Most likely state sequence of first sequence: ");
        int i2 = 0;
        while (i2 < states.length) {
            System.out.print(String.valueOf(states[i2]) + " ");
            ++i2;
        }
        System.out.println();
        System.out.println();
        System.out.println("Reestimations of model based on sequences: ");
        HiddenMarkovModelReestimator bwr = new HiddenMarkovModelReestimator(model, sequences);
        bwr.train();
        System.out.println(model + "\n");
        bwr.train();
        System.out.println(model + "\n");
        int i3 = 0;
        while (i3 < 1000) {
            bwr.train();
            ++i3;
        }
        System.out.println(model + "\n");
        fbc = new ForwardBackwardProbabilityCalculator(model, sequence);
        System.out.println("Probability of first sequence: ");
        System.out.println(fbc.calculateProbability());
        System.out.println("Probabilities of other sequences: ");
        i3 = 1;
        while (i3 < sequences.length) {
            fbc = new ForwardBackwardProbabilityCalculator(model, sequences[i3]);
            System.out.println(fbc.calculateProbability());
            ++i3;
        }
    }
}

