/*
 * Decompiled with CFR 0.152.
 */
package dist.hmm;

import dist.DiscreteDistribution;
import dist.DiscreteDistributionTable;
import dist.hmm.StateDistribution;
import shared.Copyable;
import shared.DataSet;
import shared.Instance;

public class SimpleStateDistributionTable
extends DiscreteDistributionTable
implements StateDistribution,
Copyable {
    public SimpleStateDistributionTable(double[][] probabilities) {
        super(probabilities);
    }

    public SimpleStateDistributionTable(DiscreteDistribution[] distributions) {
        super(distributions);
    }

    public double p(int nextState, Instance o) {
        Instance instance = new Instance(o.getData(), new Instance(nextState));
        return this.p(instance);
    }

    public int generateRandomState(Instance o) {
        return this.sample(o).getDiscrete();
    }

    public void estimate(double[][] expectations, DataSet observations) {
        double[][] matrix = this.getProbabilityMatrix();
        double[] sums = new double[this.getInputRange()];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                matrix[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        int t = 0;
        while (t < expectations.length) {
            int input = observations.get(t).getDiscrete();
            int j = 0;
            while (j < expectations[t].length) {
                double[] dArray = matrix[input];
                int n = j;
                dArray[n] = dArray[n] + expectations[t][j];
                int n2 = input;
                sums[n2] = sums[n2] + expectations[t][j];
                ++j;
            }
            ++t;
        }
        i = 0;
        while (i < matrix.length) {
            double[] prior = this.getDistributions()[i].getPrior();
            double m = this.getDistributions()[i].getM();
            int j = 0;
            while (j < matrix[i].length) {
                matrix[i][j] = (matrix[i][j] + m * prior[j]) / (sums[i] + m);
                ++j;
            }
            ++i;
        }
    }

    public int mostLikelyState(Instance o) {
        return this.mode(o).getDiscrete();
    }

    public Copyable copy() {
        DiscreteDistributionTable copy = (DiscreteDistributionTable)super.copy();
        SimpleStateDistributionTable sscopy = new SimpleStateDistributionTable(copy.getDistributions());
        return sscopy;
    }
}

