/*
 * Decompiled with CFR 0.152.
 */
package dist.hmm;

import dist.DiscreteDistribution;
import dist.hmm.StateDistribution;
import shared.Copyable;
import shared.DataSet;
import shared.Instance;

public class SimpleStateDistribution
extends DiscreteDistribution
implements StateDistribution,
Copyable {
    public SimpleStateDistribution(double[] probabilities) {
        super(probabilities);
    }

    public double p(int nextState, Instance observation) {
        return this.p(new Instance(nextState));
    }

    public void estimate(double[][] expectations, DataSet observations) {
        double sum = 0.0;
        double[] probabilities = this.getProbabilities();
        int i = 0;
        while (i < probabilities.length) {
            probabilities[i] = 0.0;
            ++i;
        }
        int t = 0;
        while (t < expectations.length) {
            int j = 0;
            while (j < expectations[t].length) {
                int n = j;
                probabilities[n] = probabilities[n] + expectations[t][j];
                sum += expectations[t][j];
                ++j;
            }
            ++t;
        }
        int j = 0;
        while (j < probabilities.length) {
            probabilities[j] = (probabilities[j] + this.getM() * this.getPrior()[j]) / (sum + this.getM());
            ++j;
        }
    }

    public int generateRandomState(Instance o) {
        return this.sample(o).getDiscrete();
    }

    public int mostLikelyState(Instance o) {
        return this.mode(o).getDiscrete();
    }

    public Copyable copy() {
        DiscreteDistribution copy = (DiscreteDistribution)super.copy();
        SimpleStateDistribution sscopy = new SimpleStateDistribution(copy.getProbabilities());
        sscopy.setM(this.getM());
        sscopy.setPrior(this.getPrior());
        return sscopy;
    }
}

