/*
 * Decompiled with CFR 0.152.
 */
package dist.hmm;

import dist.DiscreteDistribution;
import dist.hmm.ModularHiddenMarkovModel;
import dist.hmm.SimpleStateDistribution;
import dist.hmm.StateDistribution;
import shared.Instance;

public class SimpleHiddenMarkovModel
extends ModularHiddenMarkovModel {
    public SimpleHiddenMarkovModel(int stateCount) {
        super(stateCount);
        StateDistribution[] transitionDistributions = new StateDistribution[stateCount];
        int i = 0;
        while (i < stateCount) {
            double[] probabilities = DiscreteDistribution.random(stateCount).getProbabilities();
            transitionDistributions[i] = new SimpleStateDistribution(probabilities);
            ++i;
        }
        this.setTransitionDistributions(transitionDistributions);
        double[] probabilities = DiscreteDistribution.random(stateCount).getProbabilities();
        this.setInitialStateDistribution(new SimpleStateDistribution(probabilities));
    }

    public SimpleHiddenMarkovModel() {
    }

    public void setTransitionProbabilities(double[][] transitions) {
        StateDistribution[] transitionDistributions = new StateDistribution[this.getStateCount()];
        int i = 0;
        while (i < this.getStateCount()) {
            transitionDistributions[i] = new SimpleStateDistribution(transitions[i]);
            ++i;
        }
        this.setTransitionDistributions(transitionDistributions);
    }

    public double[][] getTransitionProbabilities() {
        double[][] probabilities = new double[this.getStateCount()][];
        int i = 0;
        while (i < probabilities.length) {
            probabilities[i] = ((SimpleStateDistribution)this.getTransitionDistributions()[i]).getProbabilities();
            ++i;
        }
        return probabilities;
    }

    public void setInitialStateProbabilities(double[] probabilities) {
        this.setInitialStateDistribution(new SimpleStateDistribution(probabilities));
    }

    public double[] getInitialStateProbabilities() {
        return ((SimpleStateDistribution)this.getInitialStateDistribution()).getProbabilities();
    }

    public void estimateIntialStateDistribution(double[][] expectations) {
        this.estimateIntialStateDistribution(expectations, null);
    }

    public void estimateTransitionDistribution(int i, double[][] expectations) {
        this.estimateTransitionDistribution(i, expectations, null);
    }

    public double initialStateProbability(int i) {
        return this.initialStateProbability(i, null);
    }

    public double transitionProbability(int i, int j) {
        return this.transitionProbability(i, j, null);
    }

    public int sampleState(int i) {
        return this.sampleState(i, null);
    }

    public int sampleInitialState() {
        return this.sampleInitialState(null);
    }

    public Instance sampleObservation(int i) {
        return this.sampleObservation(i, null);
    }
}

