/*
 * Decompiled with CFR 0.152.
 */
package dist.hmm;

import dist.Distribution;
import dist.hmm.HiddenMarkovModel;
import dist.hmm.StateDistribution;
import shared.Copyable;
import shared.DataSet;
import shared.Instance;

public class ModularHiddenMarkovModel
implements HiddenMarkovModel,
Copyable {
    private StateDistribution[] transitionDistributions;
    private Distribution[] outputDistributions;
    private StateDistribution initialStateDistribution;

    public ModularHiddenMarkovModel(int stateCount) {
        this.initialStateDistribution = null;
        this.transitionDistributions = new StateDistribution[stateCount];
        this.outputDistributions = new Distribution[stateCount];
    }

    public ModularHiddenMarkovModel() {
    }

    public int getStateCount() {
        return this.transitionDistributions.length;
    }

    public void setOutputDistributions(Distribution[] functions) {
        this.outputDistributions = functions;
    }

    public Distribution[] getOutputDistributions() {
        return this.outputDistributions;
    }

    public void setTransitionDistributions(StateDistribution[] functions) {
        this.transitionDistributions = functions;
    }

    public StateDistribution[] getTransitionDistributions() {
        return this.transitionDistributions;
    }

    public void setInitialStateDistribution(StateDistribution distribution) {
        this.initialStateDistribution = distribution;
    }

    public StateDistribution getInitialStateDistribution() {
        return this.initialStateDistribution;
    }

    public double initialStateProbability(int i, Instance o) {
        return this.initialStateDistribution.p(i, o);
    }

    public double transitionProbability(int i, int j, Instance o) {
        return this.transitionDistributions[i].p(j, o);
    }

    public double observationProbability(int i, Instance o) {
        return this.outputDistributions[i].p(o);
    }

    public int sampleState(int i, Instance o) {
        return this.transitionDistributions[i].generateRandomState(o);
    }

    public int sampleInitialState(Instance o) {
        return this.initialStateDistribution.generateRandomState(o);
    }

    public Instance sampleObservation(int i, Instance o) {
        return this.outputDistributions[i].sample(o);
    }

    public void estimateOutputDistribution(int i, DataSet sequence) {
        this.outputDistributions[i].estimate(sequence);
    }

    public void estimateIntialStateDistribution(double[][] expectations, DataSet observations) {
        this.initialStateDistribution.estimate(expectations, observations);
    }

    public void estimateTransitionDistribution(int i, double[][] expectations, DataSet sequence) {
        this.transitionDistributions[i].estimate(expectations, sequence);
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + "Transition Distributions\n";
        int i = 0;
        while (i < this.getStateCount()) {
            result = String.valueOf(result) + this.transitionDistributions[i] + "\n";
            ++i;
        }
        result = String.valueOf(result) + "Output Distributions\n";
        i = 0;
        while (i < this.getStateCount()) {
            result = String.valueOf(result) + this.outputDistributions[i] + "\n";
            ++i;
        }
        result = String.valueOf(result) + "Initial Distribution\n" + this.initialStateDistribution + "\n";
        return result;
    }

    public Copyable copy() {
        ModularHiddenMarkovModel copy = new ModularHiddenMarkovModel();
        copy.setInitialStateDistribution((StateDistribution)((Object)((Copyable)((Object)this.initialStateDistribution)).copy()));
        StateDistribution[] transitionCopies = new StateDistribution[this.transitionDistributions.length];
        int i = 0;
        while (i < transitionCopies.length) {
            transitionCopies[i] = (StateDistribution)((Object)((Copyable)((Object)this.transitionDistributions[i])).copy());
            ++i;
        }
        copy.setTransitionDistributions(transitionCopies);
        Distribution[] outputCopies = new Distribution[this.outputDistributions.length];
        int i2 = 0;
        while (i2 < outputCopies.length) {
            outputCopies[i2] = (Distribution)((Object)((Copyable)((Object)this.outputDistributions[i2])).copy());
            ++i2;
        }
        copy.setOutputDistributions(outputCopies);
        return copy;
    }
}

