/*
 * Decompiled with CFR 0.152.
 */
package dist.hmm;

import dist.hmm.HiddenMarkovModel;
import shared.DataSet;

public class ForwardBackwardProbabilityCalculator {
    private double[][] forwardProbabilities;
    private double[][] backwardProbabilities;
    private double[] scales;
    private HiddenMarkovModel model;
    private DataSet observationSequence;

    public ForwardBackwardProbabilityCalculator(HiddenMarkovModel model, DataSet observationSequence) {
        this.model = model;
        this.observationSequence = observationSequence;
    }

    public double[][] calculateForwardProbabilities() {
        this.forwardProbabilities = new double[this.observationSequence.size()][this.model.getStateCount()];
        this.scales = new double[this.observationSequence.size()];
        int i = 0;
        while (i < this.model.getStateCount()) {
            this.forwardProbabilities[0][i] = this.model.initialStateProbability(i, this.observationSequence.get(0)) * this.model.observationProbability(i, this.observationSequence.get(0));
            ++i;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < this.model.getStateCount()) {
            sum += this.forwardProbabilities[0][i2];
            ++i2;
        }
        this.scales[0] = 1.0 / sum;
        i2 = 0;
        while (i2 < this.model.getStateCount()) {
            double[] dArray = this.forwardProbabilities[0];
            int n = i2++;
            dArray[n] = dArray[n] * this.scales[0];
        }
        int t = 1;
        while (t < this.observationSequence.size()) {
            int i3 = 0;
            while (i3 < this.model.getStateCount()) {
                double priorSum = 0.0;
                int j = 0;
                while (j < this.model.getStateCount()) {
                    priorSum += this.forwardProbabilities[t - 1][j] * this.model.transitionProbability(j, i3, this.observationSequence.get(t));
                    ++j;
                }
                this.forwardProbabilities[t][i3] = priorSum * this.model.observationProbability(i3, this.observationSequence.get(t));
                ++i3;
            }
            sum = 0.0;
            i3 = 0;
            while (i3 < this.model.getStateCount()) {
                sum += this.forwardProbabilities[t][i3];
                ++i3;
            }
            this.scales[t] = 1.0 / sum;
            i3 = 0;
            while (i3 < this.model.getStateCount()) {
                double[] dArray = this.forwardProbabilities[t];
                int n = i3++;
                dArray[n] = dArray[n] * this.scales[t];
            }
            ++t;
        }
        return this.forwardProbabilities;
    }

    public double[][] calculateBackwardProbabilities() {
        if (this.scales == null) {
            this.calculateForwardProbabilities();
        }
        this.backwardProbabilities = new double[this.observationSequence.size()][this.model.getStateCount()];
        int i = 0;
        while (i < this.model.getStateCount()) {
            this.backwardProbabilities[this.observationSequence.size() - 1][i] = 1.0 * this.scales[this.observationSequence.size() - 1];
            ++i;
        }
        int t = this.observationSequence.size() - 2;
        while (t >= 0) {
            int i2 = 0;
            while (i2 < this.model.getStateCount()) {
                double futureSum = 0.0;
                int j = 0;
                while (j < this.model.getStateCount()) {
                    futureSum += this.model.transitionProbability(i2, j, this.observationSequence.get(t + 1)) * this.model.observationProbability(j, this.observationSequence.get(t + 1)) * this.backwardProbabilities[t + 1][j];
                    ++j;
                }
                this.backwardProbabilities[t][i2] = futureSum * this.scales[t];
                ++i2;
            }
            --t;
        }
        return this.backwardProbabilities;
    }

    public double calculateLogProbability() {
        if (this.scales == null) {
            this.calculateForwardProbabilities();
        }
        double sum = 0.0;
        int t = 0;
        while (t < this.observationSequence.size()) {
            sum += Math.log(this.scales[t]);
            ++t;
        }
        return -sum;
    }

    public double calculateProbability() {
        if (this.scales == null) {
            this.calculateForwardProbabilities();
        }
        double product = 1.0;
        int t = 0;
        while (t < this.observationSequence.size()) {
            product *= this.scales[t];
            ++t;
        }
        return 1.0 / product;
    }
}

