/*
 * Decompiled with CFR 0.152.
 */
package dist;

import dist.AbstractDistribution;
import dist.Distribution;
import shared.Copyable;
import shared.DataSet;
import shared.Instance;

public class UnivariateGaussian
extends AbstractDistribution
implements Copyable {
    private static final double SQRTTWOPI = Math.sqrt(Math.PI * 2);
    private double mean;
    private double sigma;

    public UnivariateGaussian(double mean, double sigma) {
        this.mean = mean;
        this.sigma = sigma;
    }

    public UnivariateGaussian() {
        this(0.0, 1.0);
    }

    public double p(Instance i) {
        double dMinusMean = i.getContinuous() - this.mean;
        return 1.0 / (SQRTTWOPI * this.sigma) * Math.exp(-0.5 * dMinusMean * dMinusMean / (this.sigma * this.sigma));
    }

    public double logp(Instance i) {
        double dMinusMean = i.getContinuous() - this.mean;
        return Math.log(1.0 / (SQRTTWOPI * this.sigma)) - 0.5 * dMinusMean * dMinusMean / (this.sigma * this.sigma);
    }

    public Instance sample(Instance i) {
        return new Instance(Distribution.random.nextGaussian() * this.sigma + this.mean);
    }

    public Instance mode(Instance i) {
        return new Instance(this.mean);
    }

    public void estimate(DataSet set) {
        this.mean = 0.0;
        int i = 0;
        while (i < set.size()) {
            this.mean += set.get(i).getContinuous();
            ++i;
        }
        this.mean /= (double)set.size();
        this.sigma = 0.0;
        i = 0;
        while (i < set.size()) {
            double dMinusMean = set.get(i).getContinuous() - this.mean;
            this.sigma += dMinusMean * dMinusMean;
            ++i;
        }
        this.sigma /= (double)(set.size() - 1);
        this.sigma = Math.sqrt(this.sigma);
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    public Copyable copy() {
        return new UnivariateGaussian(this.mean, this.sigma);
    }
}

