/*
 * Decompiled with CFR 0.152.
 */
package dist;

import dist.AbstractDistribution;
import dist.DiscreteDistribution;
import dist.Distribution;
import java.util.Arrays;
import shared.Copyable;
import shared.DataSet;
import shared.Instance;

public class MixtureDistribution
extends AbstractDistribution
implements Copyable {
    private Distribution[] components;
    private DiscreteDistribution componentDistribution;

    public MixtureDistribution(Distribution[] knowledge, DiscreteDistribution componentDistribution) {
        this.components = knowledge;
        this.componentDistribution = componentDistribution;
    }

    public MixtureDistribution(Distribution[] knowledge, double[] probabilities) {
        this(knowledge, new DiscreteDistribution(probabilities));
    }

    public void estimate(DataSet observations) {
        int t;
        double[] mixingWeights = this.componentDistribution.getProbabilities();
        double[][] componentProbabilities = new double[this.components.length][observations.size()];
        double[] weights = new double[observations.size()];
        int i = 0;
        while (i < weights.length) {
            weights[i] = observations.get(i).getWeight();
            ++i;
        }
        double[] maxLogs = new double[observations.size()];
        Arrays.fill(maxLogs, Double.NEGATIVE_INFINITY);
        int i2 = 0;
        while (i2 < this.components.length) {
            int t2 = 0;
            while (t2 < observations.size()) {
                componentProbabilities[i2][t2] = this.components[i2].logp(observations.get(t2));
                maxLogs[t2] = Math.max(componentProbabilities[i2][t2], maxLogs[t2]);
                ++t2;
            }
            ++i2;
        }
        double[] timeSums = new double[observations.size()];
        int i3 = 0;
        while (i3 < this.components.length) {
            int t3 = 0;
            while (t3 < observations.size()) {
                componentProbabilities[i3][t3] = Math.exp(componentProbabilities[i3][t3] - maxLogs[t3]) * mixingWeights[i3];
                int n = t3;
                timeSums[n] = timeSums[n] + componentProbabilities[i3][t3];
                ++t3;
            }
            ++i3;
        }
        double[] componentSums = new double[this.components.length];
        double sum = 0.0;
        int i4 = 0;
        while (i4 < this.components.length) {
            t = 0;
            while (t < observations.size()) {
                componentProbabilities[i4][t] = timeSums[t] == 0.0 ? weights[t] * mixingWeights[i4] : weights[t] * componentProbabilities[i4][t] / timeSums[t];
                int n = i4;
                componentSums[n] = componentSums[n] + componentProbabilities[i4][t];
                sum += componentProbabilities[i4][t];
                ++t;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < this.components.length) {
            t = 0;
            while (t < observations.size()) {
                observations.get(t).setWeight(componentProbabilities[i4][t]);
                ++t;
            }
            this.components[i4].estimate(observations);
            ++i4;
        }
        int t4 = 0;
        while (t4 < observations.size()) {
            observations.get(t4).setWeight(weights[t4]);
            ++t4;
        }
        double[] priors = this.componentDistribution.getPrior();
        double m = this.componentDistribution.getM();
        int i5 = 0;
        while (i5 < mixingWeights.length) {
            mixingWeights[i5] = (componentSums[i5] + m * priors[i5]) / (sum + m);
            ++i5;
        }
    }

    public Instance sample(Instance input) {
        int picked = this.componentDistribution.sample(input).getDiscrete();
        return this.components[picked].sample(input);
    }

    public Instance mode(Instance input) {
        int picked = this.componentDistribution.mode(input).getDiscrete();
        return this.components[picked].mode(input);
    }

    public double p(Instance observation) {
        double probability = 0.0;
        int i = 0;
        while (i < this.components.length) {
            probability += this.componentDistribution.p(new Instance(i)) * this.components[i].p(observation);
            ++i;
        }
        return probability;
    }

    public String toString() {
        String result = String.valueOf(this.componentDistribution.toString()) + "\n";
        int i = 0;
        while (i < this.components.length) {
            result = String.valueOf(result) + this.components[i] + "\n";
            ++i;
        }
        return String.valueOf(result) + "\n";
    }

    public DiscreteDistribution getComponentDistribution() {
        return this.componentDistribution;
    }

    public Distribution[] getComponents() {
        return this.components;
    }

    public Copyable copy() {
        Distribution[] copies = new Distribution[this.components.length];
        int i = 0;
        while (i < copies.length) {
            copies[i] = (Distribution)((Object)((Copyable)((Object)copies[i])).copy());
            ++i;
        }
        return new MixtureDistribution(copies, (DiscreteDistribution)this.componentDistribution.copy());
    }
}

