/*
 * Decompiled with CFR 0.152.
 */
package dist;

import dist.AbstractDistribution;
import dist.DiscreteDistribution;
import dist.Distribution;
import shared.Copyable;
import shared.DataSet;
import shared.Instance;

public class FixedComponentMixtureDistribution
extends AbstractDistribution
implements Copyable {
    private Distribution[] components;
    private DiscreteDistribution componentDistribution;

    public FixedComponentMixtureDistribution(Distribution[] knowledge, DiscreteDistribution componentDistribution) {
        this.components = knowledge;
        this.componentDistribution = componentDistribution;
    }

    public FixedComponentMixtureDistribution(Distribution[] knowledge, double[] probabilities) {
        this(knowledge, new DiscreteDistribution(probabilities));
    }

    public void estimate(DataSet observations) {
        double[] mixingWeights = this.componentDistribution.getProbabilities();
        double[][] componentProbabilities = new double[this.components.length][observations.size()];
        double[] weights = new double[observations.size()];
        int i = 0;
        while (i < weights.length) {
            weights[i] = observations.get(i).getWeight();
            ++i;
        }
        double[] timeSums = new double[observations.size()];
        int i2 = 0;
        while (i2 < this.components.length) {
            int t = 0;
            while (t < observations.size()) {
                componentProbabilities[i2][t] = this.components[i2].p(observations.get(t)) * mixingWeights[i2];
                int n = t;
                timeSums[n] = timeSums[n] + componentProbabilities[i2][t];
                ++t;
            }
            ++i2;
        }
        double[] componentSums = new double[this.components.length];
        double sum = 0.0;
        int i3 = 0;
        while (i3 < this.components.length) {
            int t = 0;
            while (t < observations.size()) {
                componentProbabilities[i3][t] = timeSums[t] == 0.0 ? weights[t] * mixingWeights[i3] : weights[t] * componentProbabilities[i3][t] / timeSums[t];
                int n = i3;
                componentSums[n] = componentSums[n] + componentProbabilities[i3][t];
                sum += componentProbabilities[i3][t];
                ++t;
            }
            ++i3;
        }
        double[] priors = this.componentDistribution.getPrior();
        double m = this.componentDistribution.getM();
        int i4 = 0;
        while (i4 < mixingWeights.length) {
            mixingWeights[i4] = (componentSums[i4] + m * priors[i4]) / (sum + m);
            ++i4;
        }
    }

    public Instance sample(Instance input) {
        int picked = this.componentDistribution.sample(input).getDiscrete();
        return this.components[picked].sample(input);
    }

    public Instance mode(Instance input) {
        int picked = this.componentDistribution.mode(input).getDiscrete();
        return this.components[picked].mode(input);
    }

    public double p(Instance observation) {
        double probability = 0.0;
        int i = 0;
        while (i < this.components.length) {
            probability += this.componentDistribution.p(new Instance(i)) * this.components[i].p(observation);
            ++i;
        }
        return probability;
    }

    public String toString() {
        String result = String.valueOf(this.componentDistribution.toString()) + "\n";
        int i = 0;
        while (i < this.components.length) {
            result = String.valueOf(result) + this.components[i] + "\n";
            ++i;
        }
        return String.valueOf(result) + "\n";
    }

    public DiscreteDistribution getComponentDistribution() {
        return this.componentDistribution;
    }

    public Distribution[] getComponents() {
        return this.components;
    }

    public Copyable copy() {
        return new FixedComponentMixtureDistribution(this.components, (DiscreteDistribution)this.componentDistribution.copy());
    }
}

