/*
 * Decompiled with CFR 0.152.
 */
package dist;

import dist.AbstractConditionalDistribution;
import dist.DiscreteDistribution;
import dist.Distribution;
import shared.Copyable;
import shared.DataSet;
import shared.Instance;
import util.ABAGAILArrays;

public class DiscreteDistributionTable
extends AbstractConditionalDistribution
implements Copyable {
    private DiscreteDistribution[] discreteDistributions;

    public DiscreteDistributionTable(double[][] probabilities) {
        this.discreteDistributions = new DiscreteDistribution[probabilities.length];
        int i = 0;
        while (i < this.discreteDistributions.length) {
            this.discreteDistributions[i] = new DiscreteDistribution(probabilities[i]);
            ++i;
        }
    }

    public DiscreteDistributionTable(DiscreteDistribution[] table) {
        this.discreteDistributions = table;
    }

    public Distribution distributionFor(Instance i) {
        return this.discreteDistributions[i.getDiscrete()];
    }

    public void estimate(DataSet observations) {
        double[] sums = new double[this.discreteDistributions.length];
        double[][] probabilities = this.getProbabilityMatrix();
        int i = 0;
        while (i < probabilities.length) {
            int j = 0;
            while (j < probabilities[i].length) {
                probabilities[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < observations.size()) {
            Instance cur = observations.get(i);
            int n = cur.getDiscrete();
            sums[n] = sums[n] + cur.getWeight();
            double[] dArray = probabilities[cur.getDiscrete()];
            int n2 = cur.getLabel().getDiscrete();
            dArray[n2] = dArray[n2] + cur.getWeight();
            ++i;
        }
        i = 0;
        while (i < probabilities.length) {
            double[] prior = this.discreteDistributions[i].getPrior();
            double m = this.discreteDistributions[i].getM();
            int j = 0;
            while (j < probabilities[i].length) {
                probabilities[i][j] = (probabilities[i][j] + prior[i] * m) / (sums[i] + m);
                ++j;
            }
            ++i;
        }
    }

    public double[][] getProbabilityMatrix() {
        double[][] matrix = new double[this.getInputRange()][];
        int i = 0;
        while (i < this.getInputRange()) {
            matrix[i] = this.discreteDistributions[i].getProbabilities();
            ++i;
        }
        return matrix;
    }

    public void setProbabilityMatrix(double[][] matrix) {
        int i = 0;
        while (i < this.getInputRange()) {
            this.discreteDistributions[i].setProbabilities(matrix[i]);
            ++i;
        }
    }

    public DiscreteDistribution[] getDistributions() {
        return this.discreteDistributions;
    }

    public void setDistributions(DiscreteDistribution[] distributions) {
        this.discreteDistributions = distributions;
    }

    public int getInputRange() {
        return this.discreteDistributions.length;
    }

    public int getOutputRange() {
        return this.discreteDistributions[0].getRange();
    }

    public String toString() {
        return ABAGAILArrays.toString(this.getProbabilityMatrix());
    }

    public static DiscreteDistributionTable uniform(int inputRange, int outputRange) {
        DiscreteDistribution[] table = new DiscreteDistribution[inputRange];
        int i = 0;
        while (i < table.length) {
            table[i] = DiscreteDistribution.uniform(outputRange);
            ++i;
        }
        return new DiscreteDistributionTable(table);
    }

    public static DiscreteDistributionTable random(int inputRange, int outputRange) {
        DiscreteDistribution[] table = new DiscreteDistribution[inputRange];
        int i = 0;
        while (i < table.length) {
            table[i] = DiscreteDistribution.random(outputRange);
            ++i;
        }
        return new DiscreteDistributionTable(table);
    }

    public Copyable copy() {
        DiscreteDistribution[] copies = new DiscreteDistribution[this.discreteDistributions.length];
        int i = 0;
        while (i < copies.length) {
            copies[i] = (DiscreteDistribution)this.discreteDistributions[i].copy();
            ++i;
        }
        DiscreteDistributionTable copy = new DiscreteDistributionTable(copies);
        return copy;
    }
}

