/*
 * Decompiled with CFR 0.152.
 */
package dist;

import dist.AbstractDistribution;
import dist.Distribution;
import java.io.Serializable;
import java.util.Arrays;
import shared.Copyable;
import shared.DataSet;
import shared.Instance;
import util.ABAGAILArrays;
import util.linalg.Vector;

public class DiscreteDistribution
extends AbstractDistribution
implements Serializable,
Copyable {
    private double[] probabilities;
    private double[] prior;
    private double[] cummulatives;
    private double m;

    public DiscreteDistribution(Vector vector) {
        this.m = vector.size();
        this.prior = new double[vector.size()];
        Arrays.fill(this.prior, 1.0 / (double)vector.size());
        this.probabilities = new double[vector.size()];
        int i = 0;
        while (i < vector.size()) {
            this.probabilities[i] = vector.get(i);
            ++i;
        }
        this.cummulatives = null;
    }

    public DiscreteDistribution(double[] probabilities) {
        this.probabilities = probabilities;
        this.m = probabilities.length;
        this.prior = new double[probabilities.length];
        Arrays.fill(this.prior, 1.0 / (double)probabilities.length);
        this.cummulatives = null;
    }

    public void setProbabilities(double[] probabilities) {
        this.probabilities = probabilities;
        this.cummulatives = null;
    }

    public double[] getProbabilities() {
        return this.probabilities;
    }

    public double p(Instance i) {
        return this.probabilities[i.getDiscrete()];
    }

    public Instance sample(Instance ignored) {
        if (this.cummulatives == null) {
            this.calculateCummulatives();
        }
        double rand = Distribution.random.nextDouble();
        return new Instance(ABAGAILArrays.search(this.cummulatives, rand));
    }

    private void calculateCummulatives() {
        this.cummulatives = new double[this.probabilities.length];
        this.cummulatives[0] = this.probabilities[0];
        int i = 1;
        while (i < this.cummulatives.length) {
            this.cummulatives[i] = this.cummulatives[i - 1] + this.probabilities[i];
            ++i;
        }
    }

    public Instance mode(Instance ignored) {
        int argMax = 0;
        int i = 1;
        while (i < this.probabilities.length) {
            if (this.probabilities[i] > this.probabilities[argMax]) {
                argMax = i;
            }
            ++i;
        }
        return new Instance(argMax);
    }

    public void estimate(DataSet observations) {
        double weightSum = 0.0;
        int i = 0;
        while (i < this.probabilities.length) {
            this.probabilities[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < observations.size()) {
            Instance cur = observations.get(i);
            weightSum += cur.getWeight();
            int n = cur.getDiscrete();
            this.probabilities[n] = this.probabilities[n] + cur.getWeight();
            ++i;
        }
        i = 0;
        while (i < this.probabilities.length) {
            this.probabilities[i] = (this.probabilities[i] + this.m * this.prior[i]) / (weightSum + this.m);
            ++i;
        }
        this.cummulatives = null;
    }

    public int getRange() {
        return this.probabilities.length;
    }

    public double getM() {
        return this.m;
    }

    public void setM(double d) {
        this.m = d;
    }

    public void setPrior(double[] priors) {
        this.prior = priors;
    }

    public double[] getPrior() {
        return this.prior;
    }

    public String toString() {
        return ABAGAILArrays.toString(this.probabilities);
    }

    public Copyable copy() {
        double[] copyProbabilities = new double[this.probabilities.length];
        int i = 0;
        while (i < copyProbabilities.length) {
            copyProbabilities[i] = this.probabilities[i];
            ++i;
        }
        DiscreteDistribution copy = new DiscreteDistribution(copyProbabilities);
        copy.setM(this.m);
        copy.setPrior(this.prior);
        return copy;
    }

    public static DiscreteDistribution random(int range) {
        double[] probabilities = new double[range];
        double sum = 0.0;
        int i = 0;
        while (i < probabilities.length) {
            probabilities[i] = Distribution.random.nextDouble();
            sum += probabilities[i];
            ++i;
        }
        i = 0;
        while (i < probabilities.length) {
            int n = i++;
            probabilities[n] = probabilities[n] / sum;
        }
        return new DiscreteDistribution(probabilities);
    }

    public static DiscreteDistribution uniform(int range) {
        double[] probabilities = new double[range];
        Arrays.fill(probabilities, 1.0 / (double)probabilities.length);
        return new DiscreteDistribution(probabilities);
    }
}

