/*
 * Decompiled with CFR 0.152.
 */
package dist;

import dist.DiscreteDependencyTreeNode;
import dist.DiscreteDistribution;
import shared.DataSet;
import shared.DataSetDescription;
import shared.Instance;
import util.ABAGAILArrays;
import util.graph.Edge;
import util.graph.Node;
import util.graph.Tree;

public class DiscreteDependencyTreeRootNode
extends Node {
    private double[] probabilities;

    public DiscreteDependencyTreeRootNode(DataSet dataSet, Node node, double m, Tree t) {
        DataSetDescription dsd = dataSet.getDescription();
        this.probabilities = new double[dsd.getDiscreteRange(node.getLabel())];
        double weightSum = 0.0;
        int i = 0;
        while (i < dataSet.size()) {
            int n = dataSet.get(i).getDiscrete(node.getLabel());
            this.probabilities[n] = this.probabilities[n] + dataSet.get(i).getWeight();
            weightSum += dataSet.get(i).getWeight();
            ++i;
        }
        i = 0;
        while (i < this.probabilities.length) {
            this.probabilities[i] = (this.probabilities[i] + m / (double)this.probabilities.length) / (weightSum + m);
            ++i;
        }
        t.addNode(this);
        this.setLabel(node.getLabel());
        i = 0;
        while (i < node.getEdgeCount()) {
            DiscreteDependencyTreeNode dtn = new DiscreteDependencyTreeNode(dataSet, node.getEdge(i).getOther(node), node.getLabel(), m, t);
            this.connectDirected(dtn, new Edge());
            ++i;
        }
    }

    public double probabilityOf(Instance instance) {
        DiscreteDistribution dd = new DiscreteDistribution(this.probabilities);
        double p = dd.p(new Instance(instance.getDiscrete(this.getLabel())));
        int i = 0;
        while (i < this.getEdgeCount()) {
            DiscreteDependencyTreeNode dtn = (DiscreteDependencyTreeNode)this.getEdge(i).getOther(this);
            p *= dtn.probabilityOf(instance);
            ++i;
        }
        return p;
    }

    public void generateRandom(Instance instance) {
        DiscreteDistribution dd = new DiscreteDistribution(this.probabilities);
        instance.getData().set(this.getLabel(), dd.sample(null).getDiscrete());
        int i = 0;
        while (i < this.getEdgeCount()) {
            DiscreteDependencyTreeNode dtn = (DiscreteDependencyTreeNode)this.getEdge(i).getOther(this);
            dtn.generateRandom(instance);
            ++i;
        }
    }

    public void generateMostLikely(Instance instance) {
        DiscreteDistribution dd = new DiscreteDistribution(this.probabilities);
        instance.getData().set(this.getLabel(), dd.mode(null).getDiscrete());
        int i = 0;
        while (i < this.getEdgeCount()) {
            DiscreteDependencyTreeNode dtn = (DiscreteDependencyTreeNode)this.getEdge(i).getOther(this);
            dtn.generateMostLikely(instance);
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\n" + ABAGAILArrays.toString(this.probabilities);
    }
}

