/*
 * Decompiled with CFR 0.152.
 */
package dist;

import dist.DiscreteDistribution;
import shared.DataSet;
import shared.DataSetDescription;
import shared.Instance;
import util.ABAGAILArrays;
import util.graph.Edge;
import util.graph.Node;
import util.graph.Tree;

public class DiscreteDependencyTreeNode
extends Node {
    private double[][] probabilities;
    private int parent;

    public DiscreteDependencyTreeNode(DataSet dataSet, Node node, int parent, double m, Tree t) {
        DataSetDescription dsd = dataSet.getDescription();
        double[][] probabilities = new double[dsd.getDiscreteRange(parent)][dsd.getDiscreteRange(node.getLabel())];
        double[] sums = new double[dsd.getDiscreteRange(parent)];
        int i = 0;
        while (i < dataSet.size()) {
            double[] dArray = probabilities[dataSet.get(i).getDiscrete(parent)];
            int n = dataSet.get(i).getDiscrete(node.getLabel());
            dArray[n] = dArray[n] + dataSet.get(i).getWeight();
            int n2 = dataSet.get(i).getDiscrete(parent);
            sums[n2] = sums[n2] + dataSet.get(i).getWeight();
            ++i;
        }
        i = 0;
        while (i < probabilities.length) {
            int j = 0;
            while (j < probabilities[i].length) {
                probabilities[i][j] = (probabilities[i][j] + m / (double)probabilities[i].length) / (sums[i] + m);
                ++j;
            }
            ++i;
        }
        this.probabilities = probabilities;
        this.parent = parent;
        t.addNode(this);
        this.setLabel(node.getLabel());
        i = 0;
        while (i < node.getEdgeCount()) {
            DiscreteDependencyTreeNode dtc = new DiscreteDependencyTreeNode(dataSet, node.getEdge(i).getOther(node), node.getLabel(), m, t);
            this.connectDirected(dtc, new Edge());
            ++i;
        }
    }

    public double probabilityOf(Instance sample) {
        DiscreteDistribution dd = new DiscreteDistribution(this.probabilities[sample.getDiscrete(this.parent)]);
        double p = dd.p(new Instance(sample.getDiscrete(this.getLabel())));
        int i = 0;
        while (i < this.getEdgeCount()) {
            DiscreteDependencyTreeNode dtn = (DiscreteDependencyTreeNode)this.getEdge(i).getOther(this);
            p *= dtn.probabilityOf(sample);
            ++i;
        }
        return p;
    }

    public void generateRandom(Instance sample) {
        DiscreteDistribution dd = new DiscreteDistribution(this.probabilities[sample.getDiscrete(this.parent)]);
        sample.getData().set(this.getLabel(), dd.sample(null).getDiscrete());
        int i = 0;
        while (i < this.getEdgeCount()) {
            DiscreteDependencyTreeNode dtn = (DiscreteDependencyTreeNode)this.getEdge(i).getOther(this);
            dtn.generateRandom(sample);
            ++i;
        }
    }

    public void generateMostLikely(Instance sample) {
        DiscreteDistribution dd = new DiscreteDistribution(this.probabilities[sample.getDiscrete(this.parent)]);
        sample.getData().set(this.getLabel(), dd.mode(null).getDiscrete());
        int i = 0;
        while (i < this.getEdgeCount()) {
            DiscreteDependencyTreeNode dtn = (DiscreteDependencyTreeNode)this.getEdge(i).getOther(this);
            dtn.generateRandom(sample);
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " Parent = " + this.parent + "\n" + ABAGAILArrays.toString(this.probabilities);
    }
}

